/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.ReportConfigAggregation;
import com.azure.resourcemanager.costmanagement.models.ReportConfigDatasetConfiguration;
import com.azure.resourcemanager.costmanagement.models.ReportConfigFilter;
import com.azure.resourcemanager.costmanagement.models.ReportConfigGrouping;
import com.azure.resourcemanager.costmanagement.models.ReportConfigSorting;
import com.azure.resourcemanager.costmanagement.models.ReportGranularityType;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ReportConfigDataset
implements JsonSerializable<ReportConfigDataset> {
    private ReportGranularityType granularity;
    private ReportConfigDatasetConfiguration configuration;
    private Map<String, ReportConfigAggregation> aggregation;
    private List<ReportConfigGrouping> grouping;
    private List<ReportConfigSorting> sorting;
    private ReportConfigFilter filter;

    public ReportGranularityType granularity() {
        return this.granularity;
    }

    public ReportConfigDataset withGranularity(ReportGranularityType granularity) {
        this.granularity = granularity;
        return this;
    }

    public ReportConfigDatasetConfiguration configuration() {
        return this.configuration;
    }

    public ReportConfigDataset withConfiguration(ReportConfigDatasetConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public Map<String, ReportConfigAggregation> aggregation() {
        return this.aggregation;
    }

    public ReportConfigDataset withAggregation(Map<String, ReportConfigAggregation> aggregation) {
        this.aggregation = aggregation;
        return this;
    }

    public List<ReportConfigGrouping> grouping() {
        return this.grouping;
    }

    public ReportConfigDataset withGrouping(List<ReportConfigGrouping> grouping) {
        this.grouping = grouping;
        return this;
    }

    public List<ReportConfigSorting> sorting() {
        return this.sorting;
    }

    public ReportConfigDataset withSorting(List<ReportConfigSorting> sorting) {
        this.sorting = sorting;
        return this;
    }

    public ReportConfigFilter filter() {
        return this.filter;
    }

    public ReportConfigDataset withFilter(ReportConfigFilter filter) {
        this.filter = filter;
        return this;
    }

    public void validate() {
        if (this.configuration() != null) {
            this.configuration().validate();
        }
        if (this.aggregation() != null) {
            this.aggregation().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.grouping() != null) {
            this.grouping().forEach(e -> e.validate());
        }
        if (this.sorting() != null) {
            this.sorting().forEach(e -> e.validate());
        }
        if (this.filter() != null) {
            this.filter().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("granularity", this.granularity == null ? null : this.granularity.toString());
        jsonWriter.writeJsonField("configuration", (JsonSerializable)this.configuration);
        jsonWriter.writeMapField("aggregation", this.aggregation, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("grouping", this.grouping, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("sorting", this.sorting, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("filter", (JsonSerializable)this.filter);
        return jsonWriter.writeEndObject();
    }

    public static ReportConfigDataset fromJson(JsonReader jsonReader) throws IOException {
        return (ReportConfigDataset)jsonReader.readObject(reader -> {
            ReportConfigDataset deserializedReportConfigDataset = new ReportConfigDataset();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("granularity".equals(fieldName)) {
                    deserializedReportConfigDataset.granularity = ReportGranularityType.fromString(reader.getString());
                    continue;
                }
                if ("configuration".equals(fieldName)) {
                    deserializedReportConfigDataset.configuration = ReportConfigDatasetConfiguration.fromJson(reader);
                    continue;
                }
                if ("aggregation".equals(fieldName)) {
                    Map aggregation;
                    deserializedReportConfigDataset.aggregation = aggregation = reader.readMap(reader1 -> ReportConfigAggregation.fromJson(reader1));
                    continue;
                }
                if ("grouping".equals(fieldName)) {
                    List grouping;
                    deserializedReportConfigDataset.grouping = grouping = reader.readArray(reader1 -> ReportConfigGrouping.fromJson(reader1));
                    continue;
                }
                if ("sorting".equals(fieldName)) {
                    List sorting;
                    deserializedReportConfigDataset.sorting = sorting = reader.readArray(reader1 -> ReportConfigSorting.fromJson(reader1));
                    continue;
                }
                if ("filter".equals(fieldName)) {
                    deserializedReportConfigDataset.filter = ReportConfigFilter.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReportConfigDataset;
        });
    }
}

