/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.ReportConfigComparisonExpression;
import java.io.IOException;
import java.util.List;

public final class ReportConfigFilter
implements JsonSerializable<ReportConfigFilter> {
    private List<ReportConfigFilter> and;
    private List<ReportConfigFilter> or;
    private ReportConfigComparisonExpression dimensions;
    private ReportConfigComparisonExpression tags;

    public List<ReportConfigFilter> and() {
        return this.and;
    }

    public ReportConfigFilter withAnd(List<ReportConfigFilter> and) {
        this.and = and;
        return this;
    }

    public List<ReportConfigFilter> or() {
        return this.or;
    }

    public ReportConfigFilter withOr(List<ReportConfigFilter> or) {
        this.or = or;
        return this;
    }

    public ReportConfigComparisonExpression dimensions() {
        return this.dimensions;
    }

    public ReportConfigFilter withDimensions(ReportConfigComparisonExpression dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public ReportConfigComparisonExpression tags() {
        return this.tags;
    }

    public ReportConfigFilter withTags(ReportConfigComparisonExpression tags) {
        this.tags = tags;
        return this;
    }

    public void validate() {
        if (this.and() != null) {
            this.and().forEach(e -> e.validate());
        }
        if (this.or() != null) {
            this.or().forEach(e -> e.validate());
        }
        if (this.dimensions() != null) {
            this.dimensions().validate();
        }
        if (this.tags() != null) {
            this.tags().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("and", this.and, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("or", this.or, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("dimensions", (JsonSerializable)this.dimensions);
        jsonWriter.writeJsonField("tags", (JsonSerializable)this.tags);
        return jsonWriter.writeEndObject();
    }

    public static ReportConfigFilter fromJson(JsonReader jsonReader) throws IOException {
        return (ReportConfigFilter)jsonReader.readObject(reader -> {
            ReportConfigFilter deserializedReportConfigFilter = new ReportConfigFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("and".equals(fieldName)) {
                    List and;
                    deserializedReportConfigFilter.and = and = reader.readArray(reader1 -> ReportConfigFilter.fromJson(reader1));
                    continue;
                }
                if ("or".equals(fieldName)) {
                    List or;
                    deserializedReportConfigFilter.or = or = reader.readArray(reader1 -> ReportConfigFilter.fromJson(reader1));
                    continue;
                }
                if ("dimensions".equals(fieldName)) {
                    deserializedReportConfigFilter.dimensions = ReportConfigComparisonExpression.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    deserializedReportConfigFilter.tags = ReportConfigComparisonExpression.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReportConfigFilter;
        });
    }
}

