/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.QueryColumnType;
import java.io.IOException;

public final class ReportConfigGrouping
implements JsonSerializable<ReportConfigGrouping> {
    private QueryColumnType type;
    private String name;
    private static final ClientLogger LOGGER = new ClientLogger(ReportConfigGrouping.class);

    public QueryColumnType type() {
        return this.type;
    }

    public ReportConfigGrouping withType(QueryColumnType type) {
        this.type = type;
        return this;
    }

    public String name() {
        return this.name;
    }

    public ReportConfigGrouping withName(String name) {
        this.name = name;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model ReportConfigGrouping"));
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ReportConfigGrouping"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static ReportConfigGrouping fromJson(JsonReader jsonReader) throws IOException {
        return (ReportConfigGrouping)jsonReader.readObject(reader -> {
            ReportConfigGrouping deserializedReportConfigGrouping = new ReportConfigGrouping();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedReportConfigGrouping.type = QueryColumnType.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedReportConfigGrouping.name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReportConfigGrouping;
        });
    }
}

