/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.ReportConfigSortingType;
import java.io.IOException;

public final class ReportConfigSorting
implements JsonSerializable<ReportConfigSorting> {
    private ReportConfigSortingType direction;
    private String name;
    private static final ClientLogger LOGGER = new ClientLogger(ReportConfigSorting.class);

    public ReportConfigSortingType direction() {
        return this.direction;
    }

    public ReportConfigSorting withDirection(ReportConfigSortingType direction) {
        this.direction = direction;
        return this;
    }

    public String name() {
        return this.name;
    }

    public ReportConfigSorting withName(String name) {
        this.name = name;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ReportConfigSorting"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("direction", this.direction == null ? null : this.direction.toString());
        return jsonWriter.writeEndObject();
    }

    public static ReportConfigSorting fromJson(JsonReader jsonReader) throws IOException {
        return (ReportConfigSorting)jsonReader.readObject(reader -> {
            ReportConfigSorting deserializedReportConfigSorting = new ReportConfigSorting();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedReportConfigSorting.name = reader.getString();
                    continue;
                }
                if ("direction".equals(fieldName)) {
                    deserializedReportConfigSorting.direction = ReportConfigSortingType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReportConfigSorting;
        });
    }
}

