/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.fluent.models.BenefitUtilizationSummaryInner;
import com.azure.resourcemanager.costmanagement.fluent.models.SavingsPlanUtilizationSummaryProperties;
import com.azure.resourcemanager.costmanagement.models.BenefitKind;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;

public final class SavingsPlanUtilizationSummary
extends BenefitUtilizationSummaryInner {
    private BenefitKind kind = BenefitKind.SAVINGS_PLAN;
    private SavingsPlanUtilizationSummaryProperties innerProperties;
    private String type;
    private String name;
    private String id;

    @Override
    public BenefitKind kind() {
        return this.kind;
    }

    private SavingsPlanUtilizationSummaryProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    public BigDecimal avgUtilizationPercentage() {
        return this.innerProperties() == null ? null : this.innerProperties().avgUtilizationPercentage();
    }

    public BigDecimal minUtilizationPercentage() {
        return this.innerProperties() == null ? null : this.innerProperties().minUtilizationPercentage();
    }

    public BigDecimal maxUtilizationPercentage() {
        return this.innerProperties() == null ? null : this.innerProperties().maxUtilizationPercentage();
    }

    public String armSkuName() {
        return this.innerProperties() == null ? null : this.innerProperties().armSkuName();
    }

    public String benefitId() {
        return this.innerProperties() == null ? null : this.innerProperties().benefitId();
    }

    public String benefitOrderId() {
        return this.innerProperties() == null ? null : this.innerProperties().benefitOrderId();
    }

    public BenefitKind benefitType() {
        return this.innerProperties() == null ? null : this.innerProperties().benefitType();
    }

    public SavingsPlanUtilizationSummary withBenefitType(BenefitKind benefitType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SavingsPlanUtilizationSummaryProperties();
        }
        this.innerProperties().withBenefitType(benefitType);
        return this;
    }

    public OffsetDateTime usageDate() {
        return this.innerProperties() == null ? null : this.innerProperties().usageDate();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SavingsPlanUtilizationSummary fromJson(JsonReader jsonReader) throws IOException {
        return (SavingsPlanUtilizationSummary)((Object)jsonReader.readObject(reader -> {
            SavingsPlanUtilizationSummary deserializedSavingsPlanUtilizationSummary = new SavingsPlanUtilizationSummary();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSavingsPlanUtilizationSummary.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSavingsPlanUtilizationSummary.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSavingsPlanUtilizationSummary.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedSavingsPlanUtilizationSummary.kind = BenefitKind.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSavingsPlanUtilizationSummary.innerProperties = SavingsPlanUtilizationSummaryProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSavingsPlanUtilizationSummary;
        }));
    }
}

