/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.DaysOfWeek;
import com.azure.resourcemanager.costmanagement.models.ScheduleFrequency;
import com.azure.resourcemanager.costmanagement.models.WeeksOfMonth;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class ScheduleProperties
implements JsonSerializable<ScheduleProperties> {
    private ScheduleFrequency frequency;
    private Integer hourOfDay;
    private List<DaysOfWeek> daysOfWeek;
    private List<WeeksOfMonth> weeksOfMonth;
    private Integer dayOfMonth;
    private OffsetDateTime startDate;
    private OffsetDateTime endDate;
    private static final ClientLogger LOGGER = new ClientLogger(ScheduleProperties.class);

    public ScheduleFrequency frequency() {
        return this.frequency;
    }

    public ScheduleProperties withFrequency(ScheduleFrequency frequency) {
        this.frequency = frequency;
        return this;
    }

    public Integer hourOfDay() {
        return this.hourOfDay;
    }

    public ScheduleProperties withHourOfDay(Integer hourOfDay) {
        this.hourOfDay = hourOfDay;
        return this;
    }

    public List<DaysOfWeek> daysOfWeek() {
        return this.daysOfWeek;
    }

    public ScheduleProperties withDaysOfWeek(List<DaysOfWeek> daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
        return this;
    }

    public List<WeeksOfMonth> weeksOfMonth() {
        return this.weeksOfMonth;
    }

    public ScheduleProperties withWeeksOfMonth(List<WeeksOfMonth> weeksOfMonth) {
        this.weeksOfMonth = weeksOfMonth;
        return this;
    }

    public Integer dayOfMonth() {
        return this.dayOfMonth;
    }

    public ScheduleProperties withDayOfMonth(Integer dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
        return this;
    }

    public OffsetDateTime startDate() {
        return this.startDate;
    }

    public ScheduleProperties withStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    public OffsetDateTime endDate() {
        return this.endDate;
    }

    public ScheduleProperties withEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    public void validate() {
        if (this.frequency() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property frequency in model ScheduleProperties"));
        }
        if (this.startDate() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property startDate in model ScheduleProperties"));
        }
        if (this.endDate() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property endDate in model ScheduleProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("frequency", this.frequency == null ? null : this.frequency.toString());
        jsonWriter.writeStringField("startDate", this.startDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startDate));
        jsonWriter.writeStringField("endDate", this.endDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endDate));
        jsonWriter.writeNumberField("hourOfDay", (Number)this.hourOfDay);
        jsonWriter.writeArrayField("daysOfWeek", this.daysOfWeek, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("weeksOfMonth", this.weeksOfMonth, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeNumberField("dayOfMonth", (Number)this.dayOfMonth);
        return jsonWriter.writeEndObject();
    }

    public static ScheduleProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ScheduleProperties)jsonReader.readObject(reader -> {
            ScheduleProperties deserializedScheduleProperties = new ScheduleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("frequency".equals(fieldName)) {
                    deserializedScheduleProperties.frequency = ScheduleFrequency.fromString(reader.getString());
                    continue;
                }
                if ("startDate".equals(fieldName)) {
                    deserializedScheduleProperties.startDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endDate".equals(fieldName)) {
                    deserializedScheduleProperties.endDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("hourOfDay".equals(fieldName)) {
                    deserializedScheduleProperties.hourOfDay = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("daysOfWeek".equals(fieldName)) {
                    List daysOfWeek;
                    deserializedScheduleProperties.daysOfWeek = daysOfWeek = reader.readArray(reader1 -> DaysOfWeek.fromString(reader1.getString()));
                    continue;
                }
                if ("weeksOfMonth".equals(fieldName)) {
                    List weeksOfMonth;
                    deserializedScheduleProperties.weeksOfMonth = weeksOfMonth = reader.readArray(reader1 -> WeeksOfMonth.fromString(reader1.getString()));
                    continue;
                }
                if ("dayOfMonth".equals(fieldName)) {
                    deserializedScheduleProperties.dayOfMonth = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScheduleProperties;
        });
    }
}

