/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.costmanagement.fluent.models.ScheduledActionInner;
import com.azure.resourcemanager.costmanagement.models.FileDestination;
import com.azure.resourcemanager.costmanagement.models.NotificationProperties;
import com.azure.resourcemanager.costmanagement.models.ScheduleProperties;
import com.azure.resourcemanager.costmanagement.models.ScheduledActionKind;
import com.azure.resourcemanager.costmanagement.models.ScheduledActionStatus;

public interface ScheduledAction {
    public String id();

    public String name();

    public String type();

    public String etag();

    public ScheduledActionKind kind();

    public SystemData systemData();

    public String displayName();

    public FileDestination fileDestination();

    public NotificationProperties notification();

    public String notificationEmail();

    public ScheduleProperties schedule();

    public String scope();

    public ScheduledActionStatus status();

    public String viewId();

    public ScheduledActionInner innerModel();

    public Update update();

    public ScheduledAction refresh();

    public ScheduledAction refresh(Context var1);

    public Response<Void> runByScopeWithResponse(Context var1);

    public void runByScope();

    public static interface UpdateStages {

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithViewId {
            public Update withViewId(String var1);
        }

        public static interface WithStatus {
            public Update withStatus(ScheduledActionStatus var1);
        }

        public static interface WithScope {
            public Update withScope(String var1);
        }

        public static interface WithSchedule {
            public Update withSchedule(ScheduleProperties var1);
        }

        public static interface WithNotificationEmail {
            public Update withNotificationEmail(String var1);
        }

        public static interface WithNotification {
            public Update withNotification(NotificationProperties var1);
        }

        public static interface WithFileDestination {
            public Update withFileDestination(FileDestination var1);
        }

        public static interface WithDisplayName {
            public Update withDisplayName(String var1);
        }

        public static interface WithKind {
            public Update withKind(ScheduledActionKind var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithKind,
    UpdateStages.WithDisplayName,
    UpdateStages.WithFileDestination,
    UpdateStages.WithNotification,
    UpdateStages.WithNotificationEmail,
    UpdateStages.WithSchedule,
    UpdateStages.WithScope,
    UpdateStages.WithStatus,
    UpdateStages.WithViewId,
    UpdateStages.WithIfMatch {
        public ScheduledAction apply();

        public ScheduledAction apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithViewId {
            public WithCreate withViewId(String var1);
        }

        public static interface WithStatus {
            public WithCreate withStatus(ScheduledActionStatus var1);
        }

        public static interface WithScope {
            public WithCreate withScope(String var1);
        }

        public static interface WithSchedule {
            public WithCreate withSchedule(ScheduleProperties var1);
        }

        public static interface WithNotificationEmail {
            public WithCreate withNotificationEmail(String var1);
        }

        public static interface WithNotification {
            public WithCreate withNotification(NotificationProperties var1);
        }

        public static interface WithFileDestination {
            public WithCreate withFileDestination(FileDestination var1);
        }

        public static interface WithDisplayName {
            public WithCreate withDisplayName(String var1);
        }

        public static interface WithKind {
            public WithCreate withKind(ScheduledActionKind var1);
        }

        public static interface WithCreate
        extends WithKind,
        WithDisplayName,
        WithFileDestination,
        WithNotification,
        WithNotificationEmail,
        WithSchedule,
        WithScope,
        WithStatus,
        WithViewId,
        WithIfMatch {
            public ScheduledAction create();

            public ScheduledAction create(Context var1);
        }

        public static interface WithScopeStage {
            public WithCreate withExistingScope(String var1);
        }

        public static interface Blank
        extends WithScopeStage {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithScopeStage,
    DefinitionStages.WithCreate {
    }
}

