/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.AllSavingsBenefitDetails;
import com.azure.resourcemanager.costmanagement.models.AllSavingsList;
import com.azure.resourcemanager.costmanagement.models.BenefitRecommendationProperties;
import com.azure.resourcemanager.costmanagement.models.Grain;
import com.azure.resourcemanager.costmanagement.models.LookBackPeriod;
import com.azure.resourcemanager.costmanagement.models.RecommendationUsageDetails;
import com.azure.resourcemanager.costmanagement.models.Scope;
import com.azure.resourcemanager.costmanagement.models.Term;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;

public final class SharedScopeBenefitRecommendationProperties
extends BenefitRecommendationProperties {
    private Scope scope = Scope.SHARED;

    @Override
    public Scope scope() {
        return this.scope;
    }

    @Override
    public SharedScopeBenefitRecommendationProperties withLookBackPeriod(LookBackPeriod lookBackPeriod) {
        super.withLookBackPeriod(lookBackPeriod);
        return this;
    }

    @Override
    public SharedScopeBenefitRecommendationProperties withUsage(RecommendationUsageDetails usage) {
        super.withUsage(usage);
        return this;
    }

    @Override
    public SharedScopeBenefitRecommendationProperties withTerm(Term term) {
        super.withTerm(term);
        return this;
    }

    @Override
    public SharedScopeBenefitRecommendationProperties withCommitmentGranularity(Grain commitmentGranularity) {
        super.withCommitmentGranularity(commitmentGranularity);
        return this;
    }

    @Override
    public SharedScopeBenefitRecommendationProperties withRecommendationDetails(AllSavingsBenefitDetails recommendationDetails) {
        super.withRecommendationDetails(recommendationDetails);
        return this;
    }

    @Override
    public void validate() {
        if (this.usage() != null) {
            this.usage().validate();
        }
        if (this.recommendationDetails() != null) {
            this.recommendationDetails().validate();
        }
        if (this.allRecommendationDetails() != null) {
            this.allRecommendationDetails().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lookBackPeriod", this.lookBackPeriod() == null ? null : this.lookBackPeriod().toString());
        jsonWriter.writeJsonField("usage", (JsonSerializable)this.usage());
        jsonWriter.writeStringField("term", this.term() == null ? null : this.term().toString());
        jsonWriter.writeStringField("commitmentGranularity", this.commitmentGranularity() == null ? null : this.commitmentGranularity().toString());
        jsonWriter.writeJsonField("recommendationDetails", (JsonSerializable)this.recommendationDetails());
        jsonWriter.writeStringField("scope", this.scope == null ? null : this.scope.toString());
        return jsonWriter.writeEndObject();
    }

    public static SharedScopeBenefitRecommendationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SharedScopeBenefitRecommendationProperties)jsonReader.readObject(reader -> {
            SharedScopeBenefitRecommendationProperties deserializedSharedScopeBenefitRecommendationProperties = new SharedScopeBenefitRecommendationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("firstConsumptionDate".equals(fieldName)) {
                    deserializedSharedScopeBenefitRecommendationProperties.withFirstConsumptionDate((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("lastConsumptionDate".equals(fieldName)) {
                    deserializedSharedScopeBenefitRecommendationProperties.withLastConsumptionDate((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("lookBackPeriod".equals(fieldName)) {
                    deserializedSharedScopeBenefitRecommendationProperties.withLookBackPeriod(LookBackPeriod.fromString(reader.getString()));
                    continue;
                }
                if ("totalHours".equals(fieldName)) {
                    deserializedSharedScopeBenefitRecommendationProperties.withTotalHours((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("usage".equals(fieldName)) {
                    deserializedSharedScopeBenefitRecommendationProperties.withUsage(RecommendationUsageDetails.fromJson(reader));
                    continue;
                }
                if ("armSkuName".equals(fieldName)) {
                    deserializedSharedScopeBenefitRecommendationProperties.withArmSkuName(reader.getString());
                    continue;
                }
                if ("term".equals(fieldName)) {
                    deserializedSharedScopeBenefitRecommendationProperties.withTerm(Term.fromString(reader.getString()));
                    continue;
                }
                if ("commitmentGranularity".equals(fieldName)) {
                    deserializedSharedScopeBenefitRecommendationProperties.withCommitmentGranularity(Grain.fromString(reader.getString()));
                    continue;
                }
                if ("currencyCode".equals(fieldName)) {
                    deserializedSharedScopeBenefitRecommendationProperties.withCurrencyCode(reader.getString());
                    continue;
                }
                if ("costWithoutBenefit".equals(fieldName)) {
                    deserializedSharedScopeBenefitRecommendationProperties.withCostWithoutBenefit((BigDecimal)reader.getNullable(nonNullReader -> new BigDecimal(nonNullReader.getString())));
                    continue;
                }
                if ("recommendationDetails".equals(fieldName)) {
                    deserializedSharedScopeBenefitRecommendationProperties.withRecommendationDetails(AllSavingsBenefitDetails.fromJson(reader));
                    continue;
                }
                if ("allRecommendationDetails".equals(fieldName)) {
                    deserializedSharedScopeBenefitRecommendationProperties.withAllRecommendationDetails(AllSavingsList.fromJson(reader));
                    continue;
                }
                if ("scope".equals(fieldName)) {
                    deserializedSharedScopeBenefitRecommendationProperties.scope = Scope.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSharedScopeBenefitRecommendationProperties;
        });
    }
}

