/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.costmanagement.fluent.models.ViewInner;
import com.azure.resourcemanager.costmanagement.models.AccumulatedType;
import com.azure.resourcemanager.costmanagement.models.ChartType;
import com.azure.resourcemanager.costmanagement.models.KpiProperties;
import com.azure.resourcemanager.costmanagement.models.MetricType;
import com.azure.resourcemanager.costmanagement.models.PivotProperties;
import com.azure.resourcemanager.costmanagement.models.ReportConfigDataset;
import com.azure.resourcemanager.costmanagement.models.ReportConfigTimePeriod;
import com.azure.resourcemanager.costmanagement.models.ReportTimeframeType;
import com.azure.resourcemanager.costmanagement.models.ReportType;
import java.time.OffsetDateTime;
import java.util.List;

public interface View {
    public String id();

    public String name();

    public String type();

    public String etag();

    public String displayName();

    public String scope();

    public OffsetDateTime createdOn();

    public OffsetDateTime modifiedOn();

    public String dateRange();

    public String currency();

    public ChartType chart();

    public AccumulatedType accumulated();

    public MetricType metric();

    public List<KpiProperties> kpis();

    public List<PivotProperties> pivots();

    public ReportType typePropertiesType();

    public ReportTimeframeType timeframe();

    public ReportConfigTimePeriod timePeriod();

    public ReportConfigDataset dataSet();

    public Boolean includeMonetaryCommitment();

    public ViewInner innerModel();

    public Update update();

    public View refresh();

    public View refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithIncludeMonetaryCommitment {
            public Update withIncludeMonetaryCommitment(Boolean var1);
        }

        public static interface WithDataSet {
            public Update withDataSet(ReportConfigDataset var1);
        }

        public static interface WithTimePeriod {
            public Update withTimePeriod(ReportConfigTimePeriod var1);
        }

        public static interface WithTimeframe {
            public Update withTimeframe(ReportTimeframeType var1);
        }

        public static interface WithTypePropertiesType {
            public Update withTypePropertiesType(ReportType var1);
        }

        public static interface WithPivots {
            public Update withPivots(List<PivotProperties> var1);
        }

        public static interface WithKpis {
            public Update withKpis(List<KpiProperties> var1);
        }

        public static interface WithMetric {
            public Update withMetric(MetricType var1);
        }

        public static interface WithAccumulated {
            public Update withAccumulated(AccumulatedType var1);
        }

        public static interface WithChart {
            public Update withChart(ChartType var1);
        }

        public static interface WithDateRange {
            public Update withDateRange(String var1);
        }

        public static interface WithScope {
            public Update withScope(String var1);
        }

        public static interface WithDisplayName {
            public Update withDisplayName(String var1);
        }

        public static interface WithEtag {
            public Update withEtag(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithEtag,
    UpdateStages.WithDisplayName,
    UpdateStages.WithScope,
    UpdateStages.WithDateRange,
    UpdateStages.WithChart,
    UpdateStages.WithAccumulated,
    UpdateStages.WithMetric,
    UpdateStages.WithKpis,
    UpdateStages.WithPivots,
    UpdateStages.WithTypePropertiesType,
    UpdateStages.WithTimeframe,
    UpdateStages.WithTimePeriod,
    UpdateStages.WithDataSet,
    UpdateStages.WithIncludeMonetaryCommitment {
        public View apply();

        public View apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIncludeMonetaryCommitment {
            public WithCreate withIncludeMonetaryCommitment(Boolean var1);
        }

        public static interface WithDataSet {
            public WithCreate withDataSet(ReportConfigDataset var1);
        }

        public static interface WithTimePeriod {
            public WithCreate withTimePeriod(ReportConfigTimePeriod var1);
        }

        public static interface WithTimeframe {
            public WithCreate withTimeframe(ReportTimeframeType var1);
        }

        public static interface WithTypePropertiesType {
            public WithCreate withTypePropertiesType(ReportType var1);
        }

        public static interface WithPivots {
            public WithCreate withPivots(List<PivotProperties> var1);
        }

        public static interface WithKpis {
            public WithCreate withKpis(List<KpiProperties> var1);
        }

        public static interface WithMetric {
            public WithCreate withMetric(MetricType var1);
        }

        public static interface WithAccumulated {
            public WithCreate withAccumulated(AccumulatedType var1);
        }

        public static interface WithChart {
            public WithCreate withChart(ChartType var1);
        }

        public static interface WithDateRange {
            public WithCreate withDateRange(String var1);
        }

        public static interface WithScope {
            public WithCreate withScope(String var1);
        }

        public static interface WithDisplayName {
            public WithCreate withDisplayName(String var1);
        }

        public static interface WithEtag {
            public WithCreate withEtag(String var1);
        }

        public static interface WithCreate
        extends WithEtag,
        WithDisplayName,
        WithScope,
        WithDateRange,
        WithChart,
        WithAccumulated,
        WithMetric,
        WithKpis,
        WithPivots,
        WithTypePropertiesType,
        WithTimeframe,
        WithTimePeriod,
        WithDataSet,
        WithIncludeMonetaryCommitment {
            public View create();

            public View create(Context var1);
        }

        public static interface WithScopeStage {
            public WithCreate withExistingScope(String var1);
        }

        public static interface Blank
        extends WithScopeStage {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithScopeStage,
    DefinitionStages.WithCreate {
    }
}

