/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.http.policy.ArmChallengeAuthenticationPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.DataFactoryManagementClient;
import com.azure.resourcemanager.datafactory.implementation.ActivityRunsImpl;
import com.azure.resourcemanager.datafactory.implementation.CredentialOperationsImpl;
import com.azure.resourcemanager.datafactory.implementation.DataFactoryManagementClientBuilder;
import com.azure.resourcemanager.datafactory.implementation.DataFlowDebugSessionsImpl;
import com.azure.resourcemanager.datafactory.implementation.DataFlowsImpl;
import com.azure.resourcemanager.datafactory.implementation.DatasetsImpl;
import com.azure.resourcemanager.datafactory.implementation.ExposureControlsImpl;
import com.azure.resourcemanager.datafactory.implementation.FactoriesImpl;
import com.azure.resourcemanager.datafactory.implementation.GlobalParametersImpl;
import com.azure.resourcemanager.datafactory.implementation.IntegrationRuntimeNodesImpl;
import com.azure.resourcemanager.datafactory.implementation.IntegrationRuntimeObjectMetadatasImpl;
import com.azure.resourcemanager.datafactory.implementation.IntegrationRuntimesImpl;
import com.azure.resourcemanager.datafactory.implementation.LinkedServicesImpl;
import com.azure.resourcemanager.datafactory.implementation.ManagedPrivateEndpointsImpl;
import com.azure.resourcemanager.datafactory.implementation.ManagedVirtualNetworksImpl;
import com.azure.resourcemanager.datafactory.implementation.OperationsImpl;
import com.azure.resourcemanager.datafactory.implementation.PipelineRunsImpl;
import com.azure.resourcemanager.datafactory.implementation.PipelinesImpl;
import com.azure.resourcemanager.datafactory.implementation.PrivateEndPointConnectionsImpl;
import com.azure.resourcemanager.datafactory.implementation.PrivateEndpointConnectionOperationsImpl;
import com.azure.resourcemanager.datafactory.implementation.PrivateLinkResourcesImpl;
import com.azure.resourcemanager.datafactory.implementation.TriggerRunsImpl;
import com.azure.resourcemanager.datafactory.implementation.TriggersImpl;
import com.azure.resourcemanager.datafactory.models.ActivityRuns;
import com.azure.resourcemanager.datafactory.models.CredentialOperations;
import com.azure.resourcemanager.datafactory.models.DataFlowDebugSessions;
import com.azure.resourcemanager.datafactory.models.DataFlows;
import com.azure.resourcemanager.datafactory.models.Datasets;
import com.azure.resourcemanager.datafactory.models.ExposureControls;
import com.azure.resourcemanager.datafactory.models.Factories;
import com.azure.resourcemanager.datafactory.models.GlobalParameters;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeNodes;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeObjectMetadatas;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimes;
import com.azure.resourcemanager.datafactory.models.LinkedServices;
import com.azure.resourcemanager.datafactory.models.ManagedPrivateEndpoints;
import com.azure.resourcemanager.datafactory.models.ManagedVirtualNetworks;
import com.azure.resourcemanager.datafactory.models.Operations;
import com.azure.resourcemanager.datafactory.models.PipelineRuns;
import com.azure.resourcemanager.datafactory.models.Pipelines;
import com.azure.resourcemanager.datafactory.models.PrivateEndPointConnections;
import com.azure.resourcemanager.datafactory.models.PrivateEndpointConnectionOperations;
import com.azure.resourcemanager.datafactory.models.PrivateLinkResources;
import com.azure.resourcemanager.datafactory.models.TriggerRuns;
import com.azure.resourcemanager.datafactory.models.Triggers;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class DataFactoryManager {
    private Operations operations;
    private Factories factories;
    private ExposureControls exposureControls;
    private IntegrationRuntimes integrationRuntimes;
    private IntegrationRuntimeObjectMetadatas integrationRuntimeObjectMetadatas;
    private IntegrationRuntimeNodes integrationRuntimeNodes;
    private LinkedServices linkedServices;
    private Datasets datasets;
    private Pipelines pipelines;
    private PipelineRuns pipelineRuns;
    private ActivityRuns activityRuns;
    private Triggers triggers;
    private TriggerRuns triggerRuns;
    private DataFlows dataFlows;
    private DataFlowDebugSessions dataFlowDebugSessions;
    private ManagedVirtualNetworks managedVirtualNetworks;
    private ManagedPrivateEndpoints managedPrivateEndpoints;
    private CredentialOperations credentialOperations;
    private PrivateEndPointConnections privateEndPointConnections;
    private PrivateEndpointConnectionOperations privateEndpointConnectionOperations;
    private PrivateLinkResources privateLinkResources;
    private GlobalParameters globalParameters;
    private final DataFactoryManagementClient clientObject;

    private DataFactoryManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new DataFactoryManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static DataFactoryManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return DataFactoryManager.configure().authenticate(credential, profile);
    }

    public static DataFactoryManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new DataFactoryManager(httpPipeline, profile, null);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(this.clientObject.getOperations(), this);
        }
        return this.operations;
    }

    public Factories factories() {
        if (this.factories == null) {
            this.factories = new FactoriesImpl(this.clientObject.getFactories(), this);
        }
        return this.factories;
    }

    public ExposureControls exposureControls() {
        if (this.exposureControls == null) {
            this.exposureControls = new ExposureControlsImpl(this.clientObject.getExposureControls(), this);
        }
        return this.exposureControls;
    }

    public IntegrationRuntimes integrationRuntimes() {
        if (this.integrationRuntimes == null) {
            this.integrationRuntimes = new IntegrationRuntimesImpl(this.clientObject.getIntegrationRuntimes(), this);
        }
        return this.integrationRuntimes;
    }

    public IntegrationRuntimeObjectMetadatas integrationRuntimeObjectMetadatas() {
        if (this.integrationRuntimeObjectMetadatas == null) {
            this.integrationRuntimeObjectMetadatas = new IntegrationRuntimeObjectMetadatasImpl(this.clientObject.getIntegrationRuntimeObjectMetadatas(), this);
        }
        return this.integrationRuntimeObjectMetadatas;
    }

    public IntegrationRuntimeNodes integrationRuntimeNodes() {
        if (this.integrationRuntimeNodes == null) {
            this.integrationRuntimeNodes = new IntegrationRuntimeNodesImpl(this.clientObject.getIntegrationRuntimeNodes(), this);
        }
        return this.integrationRuntimeNodes;
    }

    public LinkedServices linkedServices() {
        if (this.linkedServices == null) {
            this.linkedServices = new LinkedServicesImpl(this.clientObject.getLinkedServices(), this);
        }
        return this.linkedServices;
    }

    public Datasets datasets() {
        if (this.datasets == null) {
            this.datasets = new DatasetsImpl(this.clientObject.getDatasets(), this);
        }
        return this.datasets;
    }

    public Pipelines pipelines() {
        if (this.pipelines == null) {
            this.pipelines = new PipelinesImpl(this.clientObject.getPipelines(), this);
        }
        return this.pipelines;
    }

    public PipelineRuns pipelineRuns() {
        if (this.pipelineRuns == null) {
            this.pipelineRuns = new PipelineRunsImpl(this.clientObject.getPipelineRuns(), this);
        }
        return this.pipelineRuns;
    }

    public ActivityRuns activityRuns() {
        if (this.activityRuns == null) {
            this.activityRuns = new ActivityRunsImpl(this.clientObject.getActivityRuns(), this);
        }
        return this.activityRuns;
    }

    public Triggers triggers() {
        if (this.triggers == null) {
            this.triggers = new TriggersImpl(this.clientObject.getTriggers(), this);
        }
        return this.triggers;
    }

    public TriggerRuns triggerRuns() {
        if (this.triggerRuns == null) {
            this.triggerRuns = new TriggerRunsImpl(this.clientObject.getTriggerRuns(), this);
        }
        return this.triggerRuns;
    }

    public DataFlows dataFlows() {
        if (this.dataFlows == null) {
            this.dataFlows = new DataFlowsImpl(this.clientObject.getDataFlows(), this);
        }
        return this.dataFlows;
    }

    public DataFlowDebugSessions dataFlowDebugSessions() {
        if (this.dataFlowDebugSessions == null) {
            this.dataFlowDebugSessions = new DataFlowDebugSessionsImpl(this.clientObject.getDataFlowDebugSessions(), this);
        }
        return this.dataFlowDebugSessions;
    }

    public ManagedVirtualNetworks managedVirtualNetworks() {
        if (this.managedVirtualNetworks == null) {
            this.managedVirtualNetworks = new ManagedVirtualNetworksImpl(this.clientObject.getManagedVirtualNetworks(), this);
        }
        return this.managedVirtualNetworks;
    }

    public ManagedPrivateEndpoints managedPrivateEndpoints() {
        if (this.managedPrivateEndpoints == null) {
            this.managedPrivateEndpoints = new ManagedPrivateEndpointsImpl(this.clientObject.getManagedPrivateEndpoints(), this);
        }
        return this.managedPrivateEndpoints;
    }

    public CredentialOperations credentialOperations() {
        if (this.credentialOperations == null) {
            this.credentialOperations = new CredentialOperationsImpl(this.clientObject.getCredentialOperations(), this);
        }
        return this.credentialOperations;
    }

    public PrivateEndPointConnections privateEndPointConnections() {
        if (this.privateEndPointConnections == null) {
            this.privateEndPointConnections = new PrivateEndPointConnectionsImpl(this.clientObject.getPrivateEndPointConnections(), this);
        }
        return this.privateEndPointConnections;
    }

    public PrivateEndpointConnectionOperations privateEndpointConnectionOperations() {
        if (this.privateEndpointConnectionOperations == null) {
            this.privateEndpointConnectionOperations = new PrivateEndpointConnectionOperationsImpl(this.clientObject.getPrivateEndpointConnectionOperations(), this);
        }
        return this.privateEndpointConnectionOperations;
    }

    public PrivateLinkResources privateLinkResources() {
        if (this.privateLinkResources == null) {
            this.privateLinkResources = new PrivateLinkResourcesImpl(this.clientObject.getPrivateLinkResources(), this);
        }
        return this.privateLinkResources;
    }

    public GlobalParameters globalParameters() {
        if (this.globalParameters == null) {
            this.globalParameters = new GlobalParametersImpl(this.clientObject.getGlobalParameters(), this);
        }
        return this.globalParameters;
    }

    public DataFactoryManagementClient serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        public DataFactoryManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.datafactory").append("/").append("1.0.0-beta.19");
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = this.retryOptions != null ? new RetryPolicy(this.retryOptions) : new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new ArmChallengeAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new DataFactoryManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

