/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.BlobEventsTriggerTypeProperties;
import com.azure.resourcemanager.datafactory.models.BlobEventTypes;
import com.azure.resourcemanager.datafactory.models.MultiplePipelineTrigger;
import com.azure.resourcemanager.datafactory.models.TriggerPipelineReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="BlobEventsTrigger")
public final class BlobEventsTrigger
extends MultiplePipelineTrigger {
    @JsonProperty(value="typeProperties", required=true)
    private BlobEventsTriggerTypeProperties innerTypeProperties = new BlobEventsTriggerTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(BlobEventsTrigger.class);

    private BlobEventsTriggerTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public BlobEventsTrigger withPipelines(List<TriggerPipelineReference> pipelines) {
        super.withPipelines(pipelines);
        return this;
    }

    @Override
    public BlobEventsTrigger withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public BlobEventsTrigger withAnnotations(List<Object> annotations) {
        super.withAnnotations((List)annotations);
        return this;
    }

    public String blobPathBeginsWith() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().blobPathBeginsWith();
    }

    public BlobEventsTrigger withBlobPathBeginsWith(String blobPathBeginsWith) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new BlobEventsTriggerTypeProperties();
        }
        this.innerTypeProperties().withBlobPathBeginsWith(blobPathBeginsWith);
        return this;
    }

    public String blobPathEndsWith() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().blobPathEndsWith();
    }

    public BlobEventsTrigger withBlobPathEndsWith(String blobPathEndsWith) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new BlobEventsTriggerTypeProperties();
        }
        this.innerTypeProperties().withBlobPathEndsWith(blobPathEndsWith);
        return this;
    }

    public Boolean ignoreEmptyBlobs() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().ignoreEmptyBlobs();
    }

    public BlobEventsTrigger withIgnoreEmptyBlobs(Boolean ignoreEmptyBlobs) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new BlobEventsTriggerTypeProperties();
        }
        this.innerTypeProperties().withIgnoreEmptyBlobs(ignoreEmptyBlobs);
        return this;
    }

    public List<BlobEventTypes> events() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().events();
    }

    public BlobEventsTrigger withEvents(List<BlobEventTypes> events) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new BlobEventsTriggerTypeProperties();
        }
        this.innerTypeProperties().withEvents(events);
        return this;
    }

    public String scope() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().scope();
    }

    public BlobEventsTrigger withScope(String scope) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new BlobEventsTriggerTypeProperties();
        }
        this.innerTypeProperties().withScope(scope);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model BlobEventsTrigger"));
        }
        this.innerTypeProperties().validate();
    }
}

