/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.LicensedComponentSetupTypeProperties;
import com.azure.resourcemanager.datafactory.models.CustomSetupBase;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="ComponentSetup")
public final class ComponentSetup
extends CustomSetupBase {
    @JsonProperty(value="typeProperties", required=true)
    private LicensedComponentSetupTypeProperties innerTypeProperties = new LicensedComponentSetupTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(ComponentSetup.class);

    private LicensedComponentSetupTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    public String componentName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().componentName();
    }

    public ComponentSetup withComponentName(String componentName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new LicensedComponentSetupTypeProperties();
        }
        this.innerTypeProperties().withComponentName(componentName);
        return this;
    }

    public SecretBase licenseKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().licenseKey();
    }

    public ComponentSetup withLicenseKey(SecretBase licenseKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new LicensedComponentSetupTypeProperties();
        }
        this.innerTypeProperties().withLicenseKey(licenseKey);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model ComponentSetup"));
        }
        this.innerTypeProperties().validate();
    }
}

