/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.CustomActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.CustomActivityReferenceObject;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="Custom")
public final class CustomActivity
extends ExecutionActivity {
    @JsonProperty(value="typeProperties", required=true)
    private CustomActivityTypeProperties innerTypeProperties = new CustomActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(CustomActivity.class);

    private CustomActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public CustomActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public CustomActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public CustomActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public CustomActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public CustomActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public CustomActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public Object command() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().command();
    }

    public CustomActivity withCommand(Object command) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CustomActivityTypeProperties();
        }
        this.innerTypeProperties().withCommand(command);
        return this;
    }

    public LinkedServiceReference resourceLinkedService() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().resourceLinkedService();
    }

    public CustomActivity withResourceLinkedService(LinkedServiceReference resourceLinkedService) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CustomActivityTypeProperties();
        }
        this.innerTypeProperties().withResourceLinkedService(resourceLinkedService);
        return this;
    }

    public Object folderPath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().folderPath();
    }

    public CustomActivity withFolderPath(Object folderPath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CustomActivityTypeProperties();
        }
        this.innerTypeProperties().withFolderPath(folderPath);
        return this;
    }

    public CustomActivityReferenceObject referenceObjects() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().referenceObjects();
    }

    public CustomActivity withReferenceObjects(CustomActivityReferenceObject referenceObjects) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CustomActivityTypeProperties();
        }
        this.innerTypeProperties().withReferenceObjects(referenceObjects);
        return this;
    }

    public Map<String, Object> extendedProperties() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().extendedProperties();
    }

    public CustomActivity withExtendedProperties(Map<String, Object> extendedProperties) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CustomActivityTypeProperties();
        }
        this.innerTypeProperties().withExtendedProperties(extendedProperties);
        return this;
    }

    public Object retentionTimeInDays() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().retentionTimeInDays();
    }

    public CustomActivity withRetentionTimeInDays(Object retentionTimeInDays) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CustomActivityTypeProperties();
        }
        this.innerTypeProperties().withRetentionTimeInDays(retentionTimeInDays);
        return this;
    }

    public Object autoUserSpecification() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().autoUserSpecification();
    }

    public CustomActivity withAutoUserSpecification(Object autoUserSpecification) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CustomActivityTypeProperties();
        }
        this.innerTypeProperties().withAutoUserSpecification(autoUserSpecification);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model CustomActivity"));
        }
        this.innerTypeProperties().validate();
    }
}

