/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.DataFlowReferenceType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

public final class DataFlowReference {
    @JsonProperty(value="type", required=true)
    private DataFlowReferenceType type;
    @JsonProperty(value="referenceName", required=true)
    private String referenceName;
    @JsonProperty(value="datasetParameters")
    private Object datasetParameters;
    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, Object> parameters;
    @JsonIgnore
    private Map<String, Object> additionalProperties;
    private static final ClientLogger LOGGER = new ClientLogger(DataFlowReference.class);

    public DataFlowReferenceType type() {
        return this.type;
    }

    public DataFlowReference withType(DataFlowReferenceType type) {
        this.type = type;
        return this;
    }

    public String referenceName() {
        return this.referenceName;
    }

    public DataFlowReference withReferenceName(String referenceName) {
        this.referenceName = referenceName;
        return this;
    }

    public Object datasetParameters() {
        return this.datasetParameters;
    }

    public DataFlowReference withDatasetParameters(Object datasetParameters) {
        this.datasetParameters = datasetParameters;
        return this;
    }

    public Map<String, Object> parameters() {
        return this.parameters;
    }

    public DataFlowReference withParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public DataFlowReference withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property type in model DataFlowReference"));
        }
        if (this.referenceName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property referenceName in model DataFlowReference"));
        }
    }
}

