/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.GitHubClientSecret;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class GitHubAccessTokenRequest {
    @JsonProperty(value="gitHubAccessCode", required=true)
    private String gitHubAccessCode;
    @JsonProperty(value="gitHubClientId")
    private String gitHubClientId;
    @JsonProperty(value="gitHubClientSecret")
    private GitHubClientSecret gitHubClientSecret;
    @JsonProperty(value="gitHubAccessTokenBaseUrl", required=true)
    private String gitHubAccessTokenBaseUrl;
    private static final ClientLogger LOGGER = new ClientLogger(GitHubAccessTokenRequest.class);

    public String gitHubAccessCode() {
        return this.gitHubAccessCode;
    }

    public GitHubAccessTokenRequest withGitHubAccessCode(String gitHubAccessCode) {
        this.gitHubAccessCode = gitHubAccessCode;
        return this;
    }

    public String gitHubClientId() {
        return this.gitHubClientId;
    }

    public GitHubAccessTokenRequest withGitHubClientId(String gitHubClientId) {
        this.gitHubClientId = gitHubClientId;
        return this;
    }

    public GitHubClientSecret gitHubClientSecret() {
        return this.gitHubClientSecret;
    }

    public GitHubAccessTokenRequest withGitHubClientSecret(GitHubClientSecret gitHubClientSecret) {
        this.gitHubClientSecret = gitHubClientSecret;
        return this;
    }

    public String gitHubAccessTokenBaseUrl() {
        return this.gitHubAccessTokenBaseUrl;
    }

    public GitHubAccessTokenRequest withGitHubAccessTokenBaseUrl(String gitHubAccessTokenBaseUrl) {
        this.gitHubAccessTokenBaseUrl = gitHubAccessTokenBaseUrl;
        return this;
    }

    public void validate() {
        if (this.gitHubAccessCode() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property gitHubAccessCode in model GitHubAccessTokenRequest"));
        }
        if (this.gitHubClientSecret() != null) {
            this.gitHubClientSecret().validate();
        }
        if (this.gitHubAccessTokenBaseUrl() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property gitHubAccessTokenBaseUrl in model GitHubAccessTokenRequest"));
        }
    }
}

