/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.HDInsightStreamingActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.HDInsightActivityDebugInfoOption;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="HDInsightStreaming")
public final class HDInsightStreamingActivity
extends ExecutionActivity {
    @JsonProperty(value="typeProperties", required=true)
    private HDInsightStreamingActivityTypeProperties innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(HDInsightStreamingActivity.class);

    private HDInsightStreamingActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public HDInsightStreamingActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public HDInsightStreamingActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public HDInsightStreamingActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public HDInsightStreamingActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public HDInsightStreamingActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public HDInsightStreamingActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public List<LinkedServiceReference> storageLinkedServices() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().storageLinkedServices();
    }

    public HDInsightStreamingActivity withStorageLinkedServices(List<LinkedServiceReference> storageLinkedServices) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withStorageLinkedServices(storageLinkedServices);
        return this;
    }

    public List<Object> arguments() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().arguments();
    }

    public HDInsightStreamingActivity withArguments(List<Object> arguments) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withArguments(arguments);
        return this;
    }

    public HDInsightActivityDebugInfoOption getDebugInfo() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().getDebugInfo();
    }

    public HDInsightStreamingActivity withGetDebugInfo(HDInsightActivityDebugInfoOption getDebugInfo) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withGetDebugInfo(getDebugInfo);
        return this;
    }

    public Object mapper() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().mapper();
    }

    public HDInsightStreamingActivity withMapper(Object mapper) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withMapper(mapper);
        return this;
    }

    public Object reducer() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().reducer();
    }

    public HDInsightStreamingActivity withReducer(Object reducer) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withReducer(reducer);
        return this;
    }

    public Object input() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().input();
    }

    public HDInsightStreamingActivity withInput(Object input) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withInput(input);
        return this;
    }

    public Object output() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().output();
    }

    public HDInsightStreamingActivity withOutput(Object output) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withOutput(output);
        return this;
    }

    public List<Object> filePaths() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().filePaths();
    }

    public HDInsightStreamingActivity withFilePaths(List<Object> filePaths) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withFilePaths(filePaths);
        return this;
    }

    public LinkedServiceReference fileLinkedService() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().fileLinkedService();
    }

    public HDInsightStreamingActivity withFileLinkedService(LinkedServiceReference fileLinkedService) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withFileLinkedService(fileLinkedService);
        return this;
    }

    public Object combiner() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().combiner();
    }

    public HDInsightStreamingActivity withCombiner(Object combiner) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withCombiner(combiner);
        return this;
    }

    public List<Object> commandEnvironment() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().commandEnvironment();
    }

    public HDInsightStreamingActivity withCommandEnvironment(List<Object> commandEnvironment) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withCommandEnvironment(commandEnvironment);
        return this;
    }

    public Map<String, Object> defines() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().defines();
    }

    public HDInsightStreamingActivity withDefines(Map<String, Object> defines) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withDefines(defines);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model HDInsightStreamingActivity"));
        }
        this.innerTypeProperties().validate();
    }
}

