/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.ManagedIntegrationRuntimeTypeProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntime;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeComputeProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeCustomerVirtualNetwork;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeSsisProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeState;
import com.azure.resourcemanager.datafactory.models.ManagedVirtualNetworkReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="Managed")
public final class ManagedIntegrationRuntime
extends IntegrationRuntime {
    @JsonProperty(value="state", access=JsonProperty.Access.WRITE_ONLY)
    private IntegrationRuntimeState state;
    @JsonProperty(value="typeProperties", required=true)
    private ManagedIntegrationRuntimeTypeProperties innerTypeProperties = new ManagedIntegrationRuntimeTypeProperties();
    @JsonProperty(value="managedVirtualNetwork")
    private ManagedVirtualNetworkReference managedVirtualNetwork;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedIntegrationRuntime.class);

    public IntegrationRuntimeState state() {
        return this.state;
    }

    private ManagedIntegrationRuntimeTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    public ManagedVirtualNetworkReference managedVirtualNetwork() {
        return this.managedVirtualNetwork;
    }

    public ManagedIntegrationRuntime withManagedVirtualNetwork(ManagedVirtualNetworkReference managedVirtualNetwork) {
        this.managedVirtualNetwork = managedVirtualNetwork;
        return this;
    }

    @Override
    public ManagedIntegrationRuntime withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    public IntegrationRuntimeComputeProperties computeProperties() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().computeProperties();
    }

    public ManagedIntegrationRuntime withComputeProperties(IntegrationRuntimeComputeProperties computeProperties) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ManagedIntegrationRuntimeTypeProperties();
        }
        this.innerTypeProperties().withComputeProperties(computeProperties);
        return this;
    }

    public IntegrationRuntimeSsisProperties ssisProperties() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().ssisProperties();
    }

    public ManagedIntegrationRuntime withSsisProperties(IntegrationRuntimeSsisProperties ssisProperties) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ManagedIntegrationRuntimeTypeProperties();
        }
        this.innerTypeProperties().withSsisProperties(ssisProperties);
        return this;
    }

    public IntegrationRuntimeCustomerVirtualNetwork customerVirtualNetwork() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().customerVirtualNetwork();
    }

    public ManagedIntegrationRuntime withCustomerVirtualNetwork(IntegrationRuntimeCustomerVirtualNetwork customerVirtualNetwork) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ManagedIntegrationRuntimeTypeProperties();
        }
        this.innerTypeProperties().withCustomerVirtualNetwork(customerVirtualNetwork);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model ManagedIntegrationRuntime"));
        }
        this.innerTypeProperties().validate();
        if (this.managedVirtualNetwork() != null) {
            this.managedVirtualNetwork().validate();
        }
    }
}

