/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.ScriptActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.ScriptActivityScriptBlock;
import com.azure.resourcemanager.datafactory.models.ScriptActivityTypePropertiesLogSettings;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="Script")
public final class ScriptActivity
extends ExecutionActivity {
    @JsonProperty(value="typeProperties", required=true)
    private ScriptActivityTypeProperties innerTypeProperties = new ScriptActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(ScriptActivity.class);

    private ScriptActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public ScriptActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public ScriptActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public ScriptActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public ScriptActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ScriptActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public ScriptActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public Object scriptBlockExecutionTimeout() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().scriptBlockExecutionTimeout();
    }

    public ScriptActivity withScriptBlockExecutionTimeout(Object scriptBlockExecutionTimeout) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ScriptActivityTypeProperties();
        }
        this.innerTypeProperties().withScriptBlockExecutionTimeout(scriptBlockExecutionTimeout);
        return this;
    }

    public List<ScriptActivityScriptBlock> scripts() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().scripts();
    }

    public ScriptActivity withScripts(List<ScriptActivityScriptBlock> scripts) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ScriptActivityTypeProperties();
        }
        this.innerTypeProperties().withScripts(scripts);
        return this;
    }

    public ScriptActivityTypePropertiesLogSettings logSettings() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().logSettings();
    }

    public ScriptActivity withLogSettings(ScriptActivityTypePropertiesLogSettings logSettings) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ScriptActivityTypeProperties();
        }
        this.innerTypeProperties().withLogSettings(logSettings);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model ScriptActivity"));
        }
        this.innerTypeProperties().validate();
    }
}

