/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.XeroLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="Xero")
public final class XeroLinkedService
extends LinkedService {
    @JsonProperty(value="typeProperties", required=true)
    private XeroLinkedServiceTypeProperties innerTypeProperties = new XeroLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(XeroLinkedService.class);

    private XeroLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public XeroLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public XeroLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public XeroLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public XeroLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object connectionProperties() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectionProperties();
    }

    public XeroLinkedService withConnectionProperties(Object connectionProperties) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new XeroLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectionProperties(connectionProperties);
        return this;
    }

    public Object host() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().host();
    }

    public XeroLinkedService withHost(Object host) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new XeroLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withHost(host);
        return this;
    }

    public SecretBase consumerKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().consumerKey();
    }

    public XeroLinkedService withConsumerKey(SecretBase consumerKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new XeroLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConsumerKey(consumerKey);
        return this;
    }

    public SecretBase privateKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().privateKey();
    }

    public XeroLinkedService withPrivateKey(SecretBase privateKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new XeroLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPrivateKey(privateKey);
        return this;
    }

    public Object useEncryptedEndpoints() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().useEncryptedEndpoints();
    }

    public XeroLinkedService withUseEncryptedEndpoints(Object useEncryptedEndpoints) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new XeroLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUseEncryptedEndpoints(useEncryptedEndpoints);
        return this;
    }

    public Object useHostVerification() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().useHostVerification();
    }

    public XeroLinkedService withUseHostVerification(Object useHostVerification) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new XeroLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUseHostVerification(useHostVerification);
        return this;
    }

    public Object usePeerVerification() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().usePeerVerification();
    }

    public XeroLinkedService withUsePeerVerification(Object usePeerVerification) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new XeroLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUsePeerVerification(usePeerVerification);
        return this;
    }

    public Object encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public XeroLinkedService withEncryptedCredential(Object encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new XeroLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model XeroLinkedService"));
        }
        this.innerTypeProperties().validate();
    }
}

