// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.fluent.models.ChangeDataCaptureResourceInner;

/**
 * An instance of this class provides access to all the operations defined in ChangeDataCapturesClient.
 */
public interface ChangeDataCapturesClient {
    /**
     * Lists all resources of type change data capture.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of change data capture resources as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ChangeDataCaptureResourceInner> listByFactory(String resourceGroupName, String factoryName);

    /**
     * Lists all resources of type change data capture.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of change data capture resources as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ChangeDataCaptureResourceInner> listByFactory(String resourceGroupName, String factoryName,
        Context context);

    /**
     * Creates or updates a change data capture resource.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param changeDataCaptureName The change data capture name.
     * @param changeDataCapture Change data capture resource definition.
     * @param ifMatch ETag of the change data capture entity. Should only be specified for update, for which it should
     * match existing entity or can be * for unconditional update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return change data capture resource type along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ChangeDataCaptureResourceInner> createOrUpdateWithResponse(String resourceGroupName, String factoryName,
        String changeDataCaptureName, ChangeDataCaptureResourceInner changeDataCapture, String ifMatch,
        Context context);

    /**
     * Creates or updates a change data capture resource.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param changeDataCaptureName The change data capture name.
     * @param changeDataCapture Change data capture resource definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return change data capture resource type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ChangeDataCaptureResourceInner createOrUpdate(String resourceGroupName, String factoryName,
        String changeDataCaptureName, ChangeDataCaptureResourceInner changeDataCapture);

    /**
     * Gets a change data capture.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param changeDataCaptureName The change data capture name.
     * @param ifNoneMatch ETag of the change data capture entity. Should only be specified for get. If the ETag matches
     * the existing entity tag, or if * was provided, then no content will be returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a change data capture along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ChangeDataCaptureResourceInner> getWithResponse(String resourceGroupName, String factoryName,
        String changeDataCaptureName, String ifNoneMatch, Context context);

    /**
     * Gets a change data capture.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param changeDataCaptureName The change data capture name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a change data capture.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ChangeDataCaptureResourceInner get(String resourceGroupName, String factoryName, String changeDataCaptureName);

    /**
     * Deletes a change data capture.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param changeDataCaptureName The change data capture name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String resourceGroupName, String factoryName, String changeDataCaptureName,
        Context context);

    /**
     * Deletes a change data capture.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param changeDataCaptureName The change data capture name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String factoryName, String changeDataCaptureName);

    /**
     * Starts a change data capture.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param changeDataCaptureName The change data capture name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> startWithResponse(String resourceGroupName, String factoryName, String changeDataCaptureName,
        Context context);

    /**
     * Starts a change data capture.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param changeDataCaptureName The change data capture name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void start(String resourceGroupName, String factoryName, String changeDataCaptureName);

    /**
     * Stops a change data capture.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param changeDataCaptureName The change data capture name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> stopWithResponse(String resourceGroupName, String factoryName, String changeDataCaptureName,
        Context context);

    /**
     * Stops a change data capture.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param changeDataCaptureName The change data capture name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void stop(String resourceGroupName, String factoryName, String changeDataCaptureName);

    /**
     * Gets the current status for the change data capture resource.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param changeDataCaptureName The change data capture name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current status for the change data capture resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<String> statusWithResponse(String resourceGroupName, String factoryName, String changeDataCaptureName,
        Context context);

    /**
     * Gets the current status for the change data capture resource.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param changeDataCaptureName The change data capture name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current status for the change data capture resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    String status(String resourceGroupName, String factoryName, String changeDataCaptureName);
}
