// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent;

import com.azure.core.http.HttpPipeline;
import java.time.Duration;

/**
 * The interface for DataFactoryManagementClient class.
 */
public interface DataFactoryManagementClient {
    /**
     * Gets The subscription identifier.
     * 
     * @return the subscriptionId value.
     */
    String getSubscriptionId();

    /**
     * Gets server parameter.
     * 
     * @return the endpoint value.
     */
    String getEndpoint();

    /**
     * Gets Api Version.
     * 
     * @return the apiVersion value.
     */
    String getApiVersion();

    /**
     * Gets The HTTP pipeline to send requests through.
     * 
     * @return the httpPipeline value.
     */
    HttpPipeline getHttpPipeline();

    /**
     * Gets The default poll interval for long-running operation.
     * 
     * @return the defaultPollInterval value.
     */
    Duration getDefaultPollInterval();

    /**
     * Gets the OperationsClient object to access its operations.
     * 
     * @return the OperationsClient object.
     */
    OperationsClient getOperations();

    /**
     * Gets the FactoriesClient object to access its operations.
     * 
     * @return the FactoriesClient object.
     */
    FactoriesClient getFactories();

    /**
     * Gets the ExposureControlsClient object to access its operations.
     * 
     * @return the ExposureControlsClient object.
     */
    ExposureControlsClient getExposureControls();

    /**
     * Gets the IntegrationRuntimesClient object to access its operations.
     * 
     * @return the IntegrationRuntimesClient object.
     */
    IntegrationRuntimesClient getIntegrationRuntimes();

    /**
     * Gets the IntegrationRuntimeObjectMetadatasClient object to access its operations.
     * 
     * @return the IntegrationRuntimeObjectMetadatasClient object.
     */
    IntegrationRuntimeObjectMetadatasClient getIntegrationRuntimeObjectMetadatas();

    /**
     * Gets the IntegrationRuntimeNodesClient object to access its operations.
     * 
     * @return the IntegrationRuntimeNodesClient object.
     */
    IntegrationRuntimeNodesClient getIntegrationRuntimeNodes();

    /**
     * Gets the LinkedServicesClient object to access its operations.
     * 
     * @return the LinkedServicesClient object.
     */
    LinkedServicesClient getLinkedServices();

    /**
     * Gets the DatasetsClient object to access its operations.
     * 
     * @return the DatasetsClient object.
     */
    DatasetsClient getDatasets();

    /**
     * Gets the PipelinesClient object to access its operations.
     * 
     * @return the PipelinesClient object.
     */
    PipelinesClient getPipelines();

    /**
     * Gets the PipelineRunsClient object to access its operations.
     * 
     * @return the PipelineRunsClient object.
     */
    PipelineRunsClient getPipelineRuns();

    /**
     * Gets the ActivityRunsClient object to access its operations.
     * 
     * @return the ActivityRunsClient object.
     */
    ActivityRunsClient getActivityRuns();

    /**
     * Gets the TriggersClient object to access its operations.
     * 
     * @return the TriggersClient object.
     */
    TriggersClient getTriggers();

    /**
     * Gets the TriggerRunsClient object to access its operations.
     * 
     * @return the TriggerRunsClient object.
     */
    TriggerRunsClient getTriggerRuns();

    /**
     * Gets the DataFlowsClient object to access its operations.
     * 
     * @return the DataFlowsClient object.
     */
    DataFlowsClient getDataFlows();

    /**
     * Gets the DataFlowDebugSessionsClient object to access its operations.
     * 
     * @return the DataFlowDebugSessionsClient object.
     */
    DataFlowDebugSessionsClient getDataFlowDebugSessions();

    /**
     * Gets the ManagedVirtualNetworksClient object to access its operations.
     * 
     * @return the ManagedVirtualNetworksClient object.
     */
    ManagedVirtualNetworksClient getManagedVirtualNetworks();

    /**
     * Gets the ManagedPrivateEndpointsClient object to access its operations.
     * 
     * @return the ManagedPrivateEndpointsClient object.
     */
    ManagedPrivateEndpointsClient getManagedPrivateEndpoints();

    /**
     * Gets the CredentialOperationsClient object to access its operations.
     * 
     * @return the CredentialOperationsClient object.
     */
    CredentialOperationsClient getCredentialOperations();

    /**
     * Gets the PrivateEndPointConnectionsClient object to access its operations.
     * 
     * @return the PrivateEndPointConnectionsClient object.
     */
    PrivateEndPointConnectionsClient getPrivateEndPointConnections();

    /**
     * Gets the PrivateEndpointConnectionOperationsClient object to access its operations.
     * 
     * @return the PrivateEndpointConnectionOperationsClient object.
     */
    PrivateEndpointConnectionOperationsClient getPrivateEndpointConnectionOperations();

    /**
     * Gets the PrivateLinkResourcesClient object to access its operations.
     * 
     * @return the PrivateLinkResourcesClient object.
     */
    PrivateLinkResourcesClient getPrivateLinkResources();

    /**
     * Gets the GlobalParametersClient object to access its operations.
     * 
     * @return the GlobalParametersClient object.
     */
    GlobalParametersClient getGlobalParameters();

    /**
     * Gets the ChangeDataCapturesClient object to access its operations.
     * 
     * @return the ChangeDataCapturesClient object.
     */
    ChangeDataCapturesClient getChangeDataCaptures();
}
