// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.fluent.models.ExposureControlBatchResponseInner;
import com.azure.resourcemanager.datafactory.fluent.models.ExposureControlResponseInner;
import com.azure.resourcemanager.datafactory.models.ExposureControlBatchRequest;
import com.azure.resourcemanager.datafactory.models.ExposureControlRequest;

/**
 * An instance of this class provides access to all the operations defined in ExposureControlsClient.
 */
public interface ExposureControlsClient {
    /**
     * Get exposure control feature for specific location.
     * 
     * @param locationId The location identifier.
     * @param exposureControlRequest The exposure control request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return exposure control feature for specific location along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ExposureControlResponseInner> getFeatureValueWithResponse(String locationId,
        ExposureControlRequest exposureControlRequest, Context context);

    /**
     * Get exposure control feature for specific location.
     * 
     * @param locationId The location identifier.
     * @param exposureControlRequest The exposure control request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return exposure control feature for specific location.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ExposureControlResponseInner getFeatureValue(String locationId, ExposureControlRequest exposureControlRequest);

    /**
     * Get exposure control feature for specific factory.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param exposureControlRequest The exposure control request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return exposure control feature for specific factory along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ExposureControlResponseInner> getFeatureValueByFactoryWithResponse(String resourceGroupName,
        String factoryName, ExposureControlRequest exposureControlRequest, Context context);

    /**
     * Get exposure control feature for specific factory.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param exposureControlRequest The exposure control request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return exposure control feature for specific factory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ExposureControlResponseInner getFeatureValueByFactory(String resourceGroupName, String factoryName,
        ExposureControlRequest exposureControlRequest);

    /**
     * Get list of exposure control features for specific factory.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param exposureControlBatchRequest The exposure control request for list of features.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of exposure control features for specific factory along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ExposureControlBatchResponseInner> queryFeatureValuesByFactoryWithResponse(String resourceGroupName,
        String factoryName, ExposureControlBatchRequest exposureControlBatchRequest, Context context);

    /**
     * Get list of exposure control features for specific factory.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param exposureControlBatchRequest The exposure control request for list of features.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of exposure control features for specific factory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ExposureControlBatchResponseInner queryFeatureValuesByFactory(String resourceGroupName, String factoryName,
        ExposureControlBatchRequest exposureControlBatchRequest);
}
