// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.fluent.models.AccessPolicyResponseInner;
import com.azure.resourcemanager.datafactory.fluent.models.FactoryInner;
import com.azure.resourcemanager.datafactory.fluent.models.GitHubAccessTokenResponseInner;
import com.azure.resourcemanager.datafactory.models.FactoryRepoUpdate;
import com.azure.resourcemanager.datafactory.models.FactoryUpdateParameters;
import com.azure.resourcemanager.datafactory.models.GitHubAccessTokenRequest;
import com.azure.resourcemanager.datafactory.models.UserAccessPolicy;

/**
 * An instance of this class provides access to all the operations defined in FactoriesClient.
 */
public interface FactoriesClient {
    /**
     * Lists factories under the specified subscription.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of factory resources as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<FactoryInner> list();

    /**
     * Lists factories under the specified subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of factory resources as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<FactoryInner> list(Context context);

    /**
     * Updates a factory's repo information.
     * 
     * @param locationId The location identifier.
     * @param factoryRepoUpdate Update factory repo request definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return factory resource type along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<FactoryInner> configureFactoryRepoWithResponse(String locationId, FactoryRepoUpdate factoryRepoUpdate,
        Context context);

    /**
     * Updates a factory's repo information.
     * 
     * @param locationId The location identifier.
     * @param factoryRepoUpdate Update factory repo request definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return factory resource type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FactoryInner configureFactoryRepo(String locationId, FactoryRepoUpdate factoryRepoUpdate);

    /**
     * Lists factories.
     * 
     * @param resourceGroupName The resource group name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of factory resources as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<FactoryInner> listByResourceGroup(String resourceGroupName);

    /**
     * Lists factories.
     * 
     * @param resourceGroupName The resource group name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of factory resources as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<FactoryInner> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * Creates or updates a factory.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param factory Factory resource definition.
     * @param ifMatch ETag of the factory entity. Should only be specified for update, for which it should match
     * existing entity or can be * for unconditional update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return factory resource type along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<FactoryInner> createOrUpdateWithResponse(String resourceGroupName, String factoryName,
        FactoryInner factory, String ifMatch, Context context);

    /**
     * Creates or updates a factory.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param factory Factory resource definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return factory resource type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FactoryInner createOrUpdate(String resourceGroupName, String factoryName, FactoryInner factory);

    /**
     * Updates a factory.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param factoryUpdateParameters The parameters for updating a factory.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return factory resource type along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<FactoryInner> updateWithResponse(String resourceGroupName, String factoryName,
        FactoryUpdateParameters factoryUpdateParameters, Context context);

    /**
     * Updates a factory.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param factoryUpdateParameters The parameters for updating a factory.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return factory resource type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FactoryInner update(String resourceGroupName, String factoryName, FactoryUpdateParameters factoryUpdateParameters);

    /**
     * Gets a factory.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param ifNoneMatch ETag of the factory entity. Should only be specified for get. If the ETag matches the existing
     * entity tag, or if * was provided, then no content will be returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a factory along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<FactoryInner> getByResourceGroupWithResponse(String resourceGroupName, String factoryName,
        String ifNoneMatch, Context context);

    /**
     * Gets a factory.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a factory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FactoryInner getByResourceGroup(String resourceGroupName, String factoryName);

    /**
     * Deletes a factory.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String resourceGroupName, String factoryName, Context context);

    /**
     * Deletes a factory.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String factoryName);

    /**
     * Get GitHub Access Token.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param gitHubAccessTokenRequest Get GitHub access token request definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return gitHub Access Token along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<GitHubAccessTokenResponseInner> getGitHubAccessTokenWithResponse(String resourceGroupName,
        String factoryName, GitHubAccessTokenRequest gitHubAccessTokenRequest, Context context);

    /**
     * Get GitHub Access Token.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param gitHubAccessTokenRequest Get GitHub access token request definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return gitHub Access Token.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GitHubAccessTokenResponseInner getGitHubAccessToken(String resourceGroupName, String factoryName,
        GitHubAccessTokenRequest gitHubAccessTokenRequest);

    /**
     * Get Data Plane access.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param policy Data Plane user access policy definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data Plane access along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<AccessPolicyResponseInner> getDataPlaneAccessWithResponse(String resourceGroupName, String factoryName,
        UserAccessPolicy policy, Context context);

    /**
     * Get Data Plane access.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param policy Data Plane user access policy definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data Plane access.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AccessPolicyResponseInner getDataPlaneAccess(String resourceGroupName, String factoryName, UserAccessPolicy policy);
}
