// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.fluent.models.GlobalParameterResourceInner;

/**
 * An instance of this class provides access to all the operations defined in GlobalParametersClient.
 */
public interface GlobalParametersClient {
    /**
     * Lists Global parameters.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of Global parameters as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<GlobalParameterResourceInner> listByFactory(String resourceGroupName, String factoryName);

    /**
     * Lists Global parameters.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of Global parameters as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<GlobalParameterResourceInner> listByFactory(String resourceGroupName, String factoryName,
        Context context);

    /**
     * Gets a Global parameter.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param globalParameterName The global parameter name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Global parameter along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<GlobalParameterResourceInner> getWithResponse(String resourceGroupName, String factoryName,
        String globalParameterName, Context context);

    /**
     * Gets a Global parameter.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param globalParameterName The global parameter name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Global parameter.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GlobalParameterResourceInner get(String resourceGroupName, String factoryName, String globalParameterName);

    /**
     * Creates or updates a Global parameter.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param globalParameterName The global parameter name.
     * @param defaultParameter Global parameter resource definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return global parameters resource type along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<GlobalParameterResourceInner> createOrUpdateWithResponse(String resourceGroupName, String factoryName,
        String globalParameterName, GlobalParameterResourceInner defaultParameter, Context context);

    /**
     * Creates or updates a Global parameter.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param globalParameterName The global parameter name.
     * @param defaultParameter Global parameter resource definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return global parameters resource type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GlobalParameterResourceInner createOrUpdate(String resourceGroupName, String factoryName,
        String globalParameterName, GlobalParameterResourceInner defaultParameter);

    /**
     * Deletes a Global parameter.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param globalParameterName The global parameter name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String resourceGroupName, String factoryName, String globalParameterName,
        Context context);

    /**
     * Deletes a Global parameter.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param globalParameterName The global parameter name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String factoryName, String globalParameterName);
}
