// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.datafactory.fluent.models.IntegrationRuntimeAuthKeysInner;
import com.azure.resourcemanager.datafactory.fluent.models.IntegrationRuntimeConnectionInfoInner;
import com.azure.resourcemanager.datafactory.fluent.models.IntegrationRuntimeMonitoringDataInner;
import com.azure.resourcemanager.datafactory.fluent.models.IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponseInner;
import com.azure.resourcemanager.datafactory.fluent.models.IntegrationRuntimeResourceInner;
import com.azure.resourcemanager.datafactory.fluent.models.IntegrationRuntimeStatusResponseInner;
import com.azure.resourcemanager.datafactory.models.CreateLinkedIntegrationRuntimeRequest;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeRegenerateKeyParameters;
import com.azure.resourcemanager.datafactory.models.LinkedIntegrationRuntimeRequest;
import com.azure.resourcemanager.datafactory.models.UpdateIntegrationRuntimeRequest;

/**
 * An instance of this class provides access to all the operations defined in IntegrationRuntimesClient.
 */
public interface IntegrationRuntimesClient {
    /**
     * Lists integration runtimes.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of integration runtime resources as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<IntegrationRuntimeResourceInner> listByFactory(String resourceGroupName, String factoryName);

    /**
     * Lists integration runtimes.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of integration runtime resources as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<IntegrationRuntimeResourceInner> listByFactory(String resourceGroupName, String factoryName,
        Context context);

    /**
     * Creates or updates an integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param integrationRuntime Integration runtime resource definition.
     * @param ifMatch ETag of the integration runtime entity. Should only be specified for update, for which it should
     * match existing entity or can be * for unconditional update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return integration runtime resource type along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<IntegrationRuntimeResourceInner> createOrUpdateWithResponse(String resourceGroupName, String factoryName,
        String integrationRuntimeName, IntegrationRuntimeResourceInner integrationRuntime, String ifMatch,
        Context context);

    /**
     * Creates or updates an integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param integrationRuntime Integration runtime resource definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return integration runtime resource type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    IntegrationRuntimeResourceInner createOrUpdate(String resourceGroupName, String factoryName,
        String integrationRuntimeName, IntegrationRuntimeResourceInner integrationRuntime);

    /**
     * Gets an integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param ifNoneMatch ETag of the integration runtime entity. Should only be specified for get. If the ETag matches
     * the existing entity tag, or if * was provided, then no content will be returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an integration runtime along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<IntegrationRuntimeResourceInner> getWithResponse(String resourceGroupName, String factoryName,
        String integrationRuntimeName, String ifNoneMatch, Context context);

    /**
     * Gets an integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an integration runtime.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    IntegrationRuntimeResourceInner get(String resourceGroupName, String factoryName, String integrationRuntimeName);

    /**
     * Updates an integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param updateIntegrationRuntimeRequest The parameters for updating an integration runtime.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return integration runtime resource type along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<IntegrationRuntimeResourceInner> updateWithResponse(String resourceGroupName, String factoryName,
        String integrationRuntimeName, UpdateIntegrationRuntimeRequest updateIntegrationRuntimeRequest,
        Context context);

    /**
     * Updates an integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param updateIntegrationRuntimeRequest The parameters for updating an integration runtime.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return integration runtime resource type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    IntegrationRuntimeResourceInner update(String resourceGroupName, String factoryName, String integrationRuntimeName,
        UpdateIntegrationRuntimeRequest updateIntegrationRuntimeRequest);

    /**
     * Deletes an integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName,
        Context context);

    /**
     * Deletes an integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String factoryName, String integrationRuntimeName);

    /**
     * Gets detailed status information for an integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed status information for an integration runtime along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<IntegrationRuntimeStatusResponseInner> getStatusWithResponse(String resourceGroupName, String factoryName,
        String integrationRuntimeName, Context context);

    /**
     * Gets detailed status information for an integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed status information for an integration runtime.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    IntegrationRuntimeStatusResponseInner getStatus(String resourceGroupName, String factoryName,
        String integrationRuntimeName);

    /**
     * Gets the list of outbound network dependencies for a given Azure-SSIS integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of outbound network dependencies for a given Azure-SSIS integration runtime along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponseInner>
        listOutboundNetworkDependenciesEndpointsWithResponse(String resourceGroupName, String factoryName,
            String integrationRuntimeName, Context context);

    /**
     * Gets the list of outbound network dependencies for a given Azure-SSIS integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of outbound network dependencies for a given Azure-SSIS integration runtime.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponseInner listOutboundNetworkDependenciesEndpoints(
        String resourceGroupName, String factoryName, String integrationRuntimeName);

    /**
     * Gets the on-premises integration runtime connection information for encrypting the on-premises data source
     * credentials.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the on-premises integration runtime connection information for encrypting the on-premises data source
     * credentials along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<IntegrationRuntimeConnectionInfoInner> getConnectionInfoWithResponse(String resourceGroupName,
        String factoryName, String integrationRuntimeName, Context context);

    /**
     * Gets the on-premises integration runtime connection information for encrypting the on-premises data source
     * credentials.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the on-premises integration runtime connection information for encrypting the on-premises data source
     * credentials.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    IntegrationRuntimeConnectionInfoInner getConnectionInfo(String resourceGroupName, String factoryName,
        String integrationRuntimeName);

    /**
     * Regenerates the authentication key for an integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param regenerateKeyParameters The parameters for regenerating integration runtime authentication key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the integration runtime authentication keys along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<IntegrationRuntimeAuthKeysInner> regenerateAuthKeyWithResponse(String resourceGroupName,
        String factoryName, String integrationRuntimeName,
        IntegrationRuntimeRegenerateKeyParameters regenerateKeyParameters, Context context);

    /**
     * Regenerates the authentication key for an integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param regenerateKeyParameters The parameters for regenerating integration runtime authentication key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the integration runtime authentication keys.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    IntegrationRuntimeAuthKeysInner regenerateAuthKey(String resourceGroupName, String factoryName,
        String integrationRuntimeName, IntegrationRuntimeRegenerateKeyParameters regenerateKeyParameters);

    /**
     * Retrieves the authentication keys for an integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the integration runtime authentication keys along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<IntegrationRuntimeAuthKeysInner> listAuthKeysWithResponse(String resourceGroupName, String factoryName,
        String integrationRuntimeName, Context context);

    /**
     * Retrieves the authentication keys for an integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the integration runtime authentication keys.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    IntegrationRuntimeAuthKeysInner listAuthKeys(String resourceGroupName, String factoryName,
        String integrationRuntimeName);

    /**
     * Starts a ManagedReserved type integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of integration runtime status response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<IntegrationRuntimeStatusResponseInner>, IntegrationRuntimeStatusResponseInner>
        beginStart(String resourceGroupName, String factoryName, String integrationRuntimeName);

    /**
     * Starts a ManagedReserved type integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of integration runtime status response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<IntegrationRuntimeStatusResponseInner>, IntegrationRuntimeStatusResponseInner>
        beginStart(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context);

    /**
     * Starts a ManagedReserved type integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return integration runtime status response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    IntegrationRuntimeStatusResponseInner start(String resourceGroupName, String factoryName,
        String integrationRuntimeName);

    /**
     * Starts a ManagedReserved type integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return integration runtime status response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    IntegrationRuntimeStatusResponseInner start(String resourceGroupName, String factoryName,
        String integrationRuntimeName, Context context);

    /**
     * Stops a ManagedReserved type integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginStop(String resourceGroupName, String factoryName,
        String integrationRuntimeName);

    /**
     * Stops a ManagedReserved type integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginStop(String resourceGroupName, String factoryName,
        String integrationRuntimeName, Context context);

    /**
     * Stops a ManagedReserved type integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void stop(String resourceGroupName, String factoryName, String integrationRuntimeName);

    /**
     * Stops a ManagedReserved type integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void stop(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context);

    /**
     * Force the integration runtime to synchronize credentials across integration runtime nodes, and this will override
     * the credentials across all worker nodes with those available on the dispatcher node. If you already have the
     * latest credential backup file, you should manually import it (preferred) on any self-hosted integration runtime
     * node than using this API directly.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> syncCredentialsWithResponse(String resourceGroupName, String factoryName,
        String integrationRuntimeName, Context context);

    /**
     * Force the integration runtime to synchronize credentials across integration runtime nodes, and this will override
     * the credentials across all worker nodes with those available on the dispatcher node. If you already have the
     * latest credential backup file, you should manually import it (preferred) on any self-hosted integration runtime
     * node than using this API directly.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void syncCredentials(String resourceGroupName, String factoryName, String integrationRuntimeName);

    /**
     * Get the integration runtime monitoring data, which includes the monitor data for all the nodes under this
     * integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the integration runtime monitoring data, which includes the monitor data for all the nodes under this
     * integration runtime along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<IntegrationRuntimeMonitoringDataInner> getMonitoringDataWithResponse(String resourceGroupName,
        String factoryName, String integrationRuntimeName, Context context);

    /**
     * Get the integration runtime monitoring data, which includes the monitor data for all the nodes under this
     * integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the integration runtime monitoring data, which includes the monitor data for all the nodes under this
     * integration runtime.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    IntegrationRuntimeMonitoringDataInner getMonitoringData(String resourceGroupName, String factoryName,
        String integrationRuntimeName);

    /**
     * Upgrade self-hosted integration runtime to latest version if availability.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> upgradeWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName,
        Context context);

    /**
     * Upgrade self-hosted integration runtime to latest version if availability.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void upgrade(String resourceGroupName, String factoryName, String integrationRuntimeName);

    /**
     * Remove all linked integration runtimes under specific data factory in a self-hosted integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param linkedIntegrationRuntimeRequest The data factory name for the linked integration runtime.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> removeLinksWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName,
        LinkedIntegrationRuntimeRequest linkedIntegrationRuntimeRequest, Context context);

    /**
     * Remove all linked integration runtimes under specific data factory in a self-hosted integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param linkedIntegrationRuntimeRequest The data factory name for the linked integration runtime.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void removeLinks(String resourceGroupName, String factoryName, String integrationRuntimeName,
        LinkedIntegrationRuntimeRequest linkedIntegrationRuntimeRequest);

    /**
     * Create a linked integration runtime entry in a shared integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param createLinkedIntegrationRuntimeRequest The linked integration runtime properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return integration runtime status response along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<IntegrationRuntimeStatusResponseInner> createLinkedIntegrationRuntimeWithResponse(String resourceGroupName,
        String factoryName, String integrationRuntimeName,
        CreateLinkedIntegrationRuntimeRequest createLinkedIntegrationRuntimeRequest, Context context);

    /**
     * Create a linked integration runtime entry in a shared integration runtime.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param createLinkedIntegrationRuntimeRequest The linked integration runtime properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return integration runtime status response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    IntegrationRuntimeStatusResponseInner createLinkedIntegrationRuntime(String resourceGroupName, String factoryName,
        String integrationRuntimeName, CreateLinkedIntegrationRuntimeRequest createLinkedIntegrationRuntimeRequest);
}
