// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * AmazonRdsForOracle dataset properties.
 */
@Fluent
public final class AmazonRdsForOracleTableDatasetTypeProperties {
    /*
     * The schema name of the AmazonRdsForOracle database. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "schema")
    private Object schema;

    /*
     * The table name of the AmazonRdsForOracle database. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "table")
    private Object table;

    /**
     * Creates an instance of AmazonRdsForOracleTableDatasetTypeProperties class.
     */
    public AmazonRdsForOracleTableDatasetTypeProperties() {
    }

    /**
     * Get the schema property: The schema name of the AmazonRdsForOracle database. Type: string (or Expression with
     * resultType string).
     * 
     * @return the schema value.
     */
    public Object schema() {
        return this.schema;
    }

    /**
     * Set the schema property: The schema name of the AmazonRdsForOracle database. Type: string (or Expression with
     * resultType string).
     * 
     * @param schema the schema value to set.
     * @return the AmazonRdsForOracleTableDatasetTypeProperties object itself.
     */
    public AmazonRdsForOracleTableDatasetTypeProperties withSchema(Object schema) {
        this.schema = schema;
        return this;
    }

    /**
     * Get the table property: The table name of the AmazonRdsForOracle database. Type: string (or Expression with
     * resultType string).
     * 
     * @return the table value.
     */
    public Object table() {
        return this.table;
    }

    /**
     * Set the table property: The table name of the AmazonRdsForOracle database. Type: string (or Expression with
     * resultType string).
     * 
     * @param table the table value to set.
     * @return the AmazonRdsForOracleTableDatasetTypeProperties object itself.
     */
    public AmazonRdsForOracleTableDatasetTypeProperties withTable(Object table) {
        this.table = table;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
