// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.SqlAlwaysEncryptedProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Amazon Rds for SQL Server linked service properties.
 */
@Fluent
public final class AmazonRdsForSqlServerLinkedServiceTypeProperties {
    /*
     * The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JsonProperty(value = "connectionString", required = true)
    private Object connectionString;

    /*
     * The on-premises Windows authentication user name. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "userName")
    private Object username;

    /*
     * The on-premises Windows authentication password.
     */
    @JsonProperty(value = "password")
    private SecretBase password;

    /*
     * The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JsonProperty(value = "encryptedCredential")
    private String encryptedCredential;

    /*
     * Sql always encrypted properties.
     */
    @JsonProperty(value = "alwaysEncryptedSettings")
    private SqlAlwaysEncryptedProperties alwaysEncryptedSettings;

    /**
     * Creates an instance of AmazonRdsForSqlServerLinkedServiceTypeProperties class.
     */
    public AmazonRdsForSqlServerLinkedServiceTypeProperties() {
    }

    /**
     * Get the connectionString property: The connection string. Type: string, SecureString or
     * AzureKeyVaultSecretReference.
     * 
     * @return the connectionString value.
     */
    public Object connectionString() {
        return this.connectionString;
    }

    /**
     * Set the connectionString property: The connection string. Type: string, SecureString or
     * AzureKeyVaultSecretReference.
     * 
     * @param connectionString the connectionString value to set.
     * @return the AmazonRdsForSqlServerLinkedServiceTypeProperties object itself.
     */
    public AmazonRdsForSqlServerLinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    /**
     * Get the username property: The on-premises Windows authentication user name. Type: string (or Expression with
     * resultType string).
     * 
     * @return the username value.
     */
    public Object username() {
        return this.username;
    }

    /**
     * Set the username property: The on-premises Windows authentication user name. Type: string (or Expression with
     * resultType string).
     * 
     * @param username the username value to set.
     * @return the AmazonRdsForSqlServerLinkedServiceTypeProperties object itself.
     */
    public AmazonRdsForSqlServerLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    /**
     * Get the password property: The on-premises Windows authentication password.
     * 
     * @return the password value.
     */
    public SecretBase password() {
        return this.password;
    }

    /**
     * Set the password property: The on-premises Windows authentication password.
     * 
     * @param password the password value to set.
     * @return the AmazonRdsForSqlServerLinkedServiceTypeProperties object itself.
     */
    public AmazonRdsForSqlServerLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the AmazonRdsForSqlServerLinkedServiceTypeProperties object itself.
     */
    public AmazonRdsForSqlServerLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    /**
     * Get the alwaysEncryptedSettings property: Sql always encrypted properties.
     * 
     * @return the alwaysEncryptedSettings value.
     */
    public SqlAlwaysEncryptedProperties alwaysEncryptedSettings() {
        return this.alwaysEncryptedSettings;
    }

    /**
     * Set the alwaysEncryptedSettings property: Sql always encrypted properties.
     * 
     * @param alwaysEncryptedSettings the alwaysEncryptedSettings value to set.
     * @return the AmazonRdsForSqlServerLinkedServiceTypeProperties object itself.
     */
    public AmazonRdsForSqlServerLinkedServiceTypeProperties
        withAlwaysEncryptedSettings(SqlAlwaysEncryptedProperties alwaysEncryptedSettings) {
        this.alwaysEncryptedSettings = alwaysEncryptedSettings;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (connectionString() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property connectionString in model AmazonRdsForSqlServerLinkedServiceTypeProperties"));
        }
        if (password() != null) {
            password().validate();
        }
        if (alwaysEncryptedSettings() != null) {
            alwaysEncryptedSettings().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AmazonRdsForSqlServerLinkedServiceTypeProperties.class);
}
