// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * AppFigures linked service type properties.
 */
@Fluent
public final class AppFiguresLinkedServiceTypeProperties {
    /*
     * The username of the Appfigures source. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "userName", required = true)
    private Object username;

    /*
     * The password of the AppFigures source.
     */
    @JsonProperty(value = "password", required = true)
    private SecretBase password;

    /*
     * The client key for the AppFigures source.
     */
    @JsonProperty(value = "clientKey", required = true)
    private SecretBase clientKey;

    /**
     * Creates an instance of AppFiguresLinkedServiceTypeProperties class.
     */
    public AppFiguresLinkedServiceTypeProperties() {
    }

    /**
     * Get the username property: The username of the Appfigures source. Type: string (or Expression with resultType
     * string).
     * 
     * @return the username value.
     */
    public Object username() {
        return this.username;
    }

    /**
     * Set the username property: The username of the Appfigures source. Type: string (or Expression with resultType
     * string).
     * 
     * @param username the username value to set.
     * @return the AppFiguresLinkedServiceTypeProperties object itself.
     */
    public AppFiguresLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    /**
     * Get the password property: The password of the AppFigures source.
     * 
     * @return the password value.
     */
    public SecretBase password() {
        return this.password;
    }

    /**
     * Set the password property: The password of the AppFigures source.
     * 
     * @param password the password value to set.
     * @return the AppFiguresLinkedServiceTypeProperties object itself.
     */
    public AppFiguresLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    /**
     * Get the clientKey property: The client key for the AppFigures source.
     * 
     * @return the clientKey value.
     */
    public SecretBase clientKey() {
        return this.clientKey;
    }

    /**
     * Set the clientKey property: The client key for the AppFigures source.
     * 
     * @param clientKey the clientKey value to set.
     * @return the AppFiguresLinkedServiceTypeProperties object itself.
     */
    public AppFiguresLinkedServiceTypeProperties withClientKey(SecretBase clientKey) {
        this.clientKey = clientKey;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (username() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property username in model AppFiguresLinkedServiceTypeProperties"));
        }
        if (password() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property password in model AppFiguresLinkedServiceTypeProperties"));
        } else {
            password().validate();
        }
        if (clientKey() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property clientKey in model AppFiguresLinkedServiceTypeProperties"));
        } else {
            clientKey().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AppFiguresLinkedServiceTypeProperties.class);
}
