// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Installation of Azure PowerShell type properties.
 */
@Fluent
public final class AzPowerShellSetupTypeProperties {
    /*
     * The required version of Azure PowerShell to install.
     */
    @JsonProperty(value = "version", required = true)
    private String version;

    /**
     * Creates an instance of AzPowerShellSetupTypeProperties class.
     */
    public AzPowerShellSetupTypeProperties() {
    }

    /**
     * Get the version property: The required version of Azure PowerShell to install.
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Set the version property: The required version of Azure PowerShell to install.
     * 
     * @param version the version value to set.
     * @return the AzPowerShellSetupTypeProperties object itself.
     */
    public AzPowerShellSetupTypeProperties withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (version() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property version in model AzPowerShellSetupTypeProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AzPowerShellSetupTypeProperties.class);
}
