// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.datafactory.models.DatasetCompression;
import com.azure.resourcemanager.datafactory.models.DatasetStorageFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Azure Blob dataset properties.
 */
@Fluent
public final class AzureBlobDatasetTypeProperties {
    /*
     * The path of the Azure Blob storage. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "folderPath")
    private Object folderPath;

    /*
     * The root of blob path. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "tableRootLocation")
    private Object tableRootLocation;

    /*
     * The name of the Azure Blob. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "fileName")
    private Object fileName;

    /*
     * The start of Azure Blob's modified datetime. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "modifiedDatetimeStart")
    private Object modifiedDatetimeStart;

    /*
     * The end of Azure Blob's modified datetime. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "modifiedDatetimeEnd")
    private Object modifiedDatetimeEnd;

    /*
     * The format of the Azure Blob storage.
     */
    @JsonProperty(value = "format")
    private DatasetStorageFormat format;

    /*
     * The data compression method used for the blob storage.
     */
    @JsonProperty(value = "compression")
    private DatasetCompression compression;

    /**
     * Creates an instance of AzureBlobDatasetTypeProperties class.
     */
    public AzureBlobDatasetTypeProperties() {
    }

    /**
     * Get the folderPath property: The path of the Azure Blob storage. Type: string (or Expression with resultType
     * string).
     * 
     * @return the folderPath value.
     */
    public Object folderPath() {
        return this.folderPath;
    }

    /**
     * Set the folderPath property: The path of the Azure Blob storage. Type: string (or Expression with resultType
     * string).
     * 
     * @param folderPath the folderPath value to set.
     * @return the AzureBlobDatasetTypeProperties object itself.
     */
    public AzureBlobDatasetTypeProperties withFolderPath(Object folderPath) {
        this.folderPath = folderPath;
        return this;
    }

    /**
     * Get the tableRootLocation property: The root of blob path. Type: string (or Expression with resultType string).
     * 
     * @return the tableRootLocation value.
     */
    public Object tableRootLocation() {
        return this.tableRootLocation;
    }

    /**
     * Set the tableRootLocation property: The root of blob path. Type: string (or Expression with resultType string).
     * 
     * @param tableRootLocation the tableRootLocation value to set.
     * @return the AzureBlobDatasetTypeProperties object itself.
     */
    public AzureBlobDatasetTypeProperties withTableRootLocation(Object tableRootLocation) {
        this.tableRootLocation = tableRootLocation;
        return this;
    }

    /**
     * Get the fileName property: The name of the Azure Blob. Type: string (or Expression with resultType string).
     * 
     * @return the fileName value.
     */
    public Object fileName() {
        return this.fileName;
    }

    /**
     * Set the fileName property: The name of the Azure Blob. Type: string (or Expression with resultType string).
     * 
     * @param fileName the fileName value to set.
     * @return the AzureBlobDatasetTypeProperties object itself.
     */
    public AzureBlobDatasetTypeProperties withFileName(Object fileName) {
        this.fileName = fileName;
        return this;
    }

    /**
     * Get the modifiedDatetimeStart property: The start of Azure Blob's modified datetime. Type: string (or Expression
     * with resultType string).
     * 
     * @return the modifiedDatetimeStart value.
     */
    public Object modifiedDatetimeStart() {
        return this.modifiedDatetimeStart;
    }

    /**
     * Set the modifiedDatetimeStart property: The start of Azure Blob's modified datetime. Type: string (or Expression
     * with resultType string).
     * 
     * @param modifiedDatetimeStart the modifiedDatetimeStart value to set.
     * @return the AzureBlobDatasetTypeProperties object itself.
     */
    public AzureBlobDatasetTypeProperties withModifiedDatetimeStart(Object modifiedDatetimeStart) {
        this.modifiedDatetimeStart = modifiedDatetimeStart;
        return this;
    }

    /**
     * Get the modifiedDatetimeEnd property: The end of Azure Blob's modified datetime. Type: string (or Expression with
     * resultType string).
     * 
     * @return the modifiedDatetimeEnd value.
     */
    public Object modifiedDatetimeEnd() {
        return this.modifiedDatetimeEnd;
    }

    /**
     * Set the modifiedDatetimeEnd property: The end of Azure Blob's modified datetime. Type: string (or Expression with
     * resultType string).
     * 
     * @param modifiedDatetimeEnd the modifiedDatetimeEnd value to set.
     * @return the AzureBlobDatasetTypeProperties object itself.
     */
    public AzureBlobDatasetTypeProperties withModifiedDatetimeEnd(Object modifiedDatetimeEnd) {
        this.modifiedDatetimeEnd = modifiedDatetimeEnd;
        return this;
    }

    /**
     * Get the format property: The format of the Azure Blob storage.
     * 
     * @return the format value.
     */
    public DatasetStorageFormat format() {
        return this.format;
    }

    /**
     * Set the format property: The format of the Azure Blob storage.
     * 
     * @param format the format value to set.
     * @return the AzureBlobDatasetTypeProperties object itself.
     */
    public AzureBlobDatasetTypeProperties withFormat(DatasetStorageFormat format) {
        this.format = format;
        return this;
    }

    /**
     * Get the compression property: The data compression method used for the blob storage.
     * 
     * @return the compression value.
     */
    public DatasetCompression compression() {
        return this.compression;
    }

    /**
     * Set the compression property: The data compression method used for the blob storage.
     * 
     * @param compression the compression value to set.
     * @return the AzureBlobDatasetTypeProperties object itself.
     */
    public AzureBlobDatasetTypeProperties withCompression(DatasetCompression compression) {
        this.compression = compression;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (format() != null) {
            format().validate();
        }
        if (compression() != null) {
            compression().validate();
        }
    }
}
