// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import com.azure.resourcemanager.datafactory.models.AzureStorageAuthenticationType;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Azure Blob Storage linked service properties.
 */
@Fluent
public final class AzureBlobStorageLinkedServiceTypeProperties {
    /*
     * The connection string. It is mutually exclusive with sasUri, serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JsonProperty(value = "connectionString")
    private Object connectionString;

    /*
     * The Azure key vault secret reference of accountKey in connection string.
     */
    @JsonProperty(value = "accountKey")
    private AzureKeyVaultSecretReference accountKey;

    /*
     * SAS URI of the Azure Blob Storage resource. It is mutually exclusive with connectionString, serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JsonProperty(value = "sasUri")
    private Object sasUri;

    /*
     * The Azure key vault secret reference of sasToken in sas uri.
     */
    @JsonProperty(value = "sasToken")
    private AzureKeyVaultSecretReference sasToken;

    /*
     * Blob service endpoint of the Azure Blob Storage resource. It is mutually exclusive with connectionString, sasUri property.
     */
    @JsonProperty(value = "serviceEndpoint")
    private Object serviceEndpoint;

    /*
     * The ID of the service principal used to authenticate against Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "servicePrincipalId")
    private Object servicePrincipalId;

    /*
     * The key of the service principal used to authenticate against Azure SQL Data Warehouse.
     */
    @JsonProperty(value = "servicePrincipalKey")
    private SecretBase servicePrincipalKey;

    /*
     * The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "tenant")
    private Object tenant;

    /*
     * Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "azureCloudType")
    private Object azureCloudType;

    /*
     * Specify the kind of your storage account. Allowed values are: Storage (general purpose v1), StorageV2 (general purpose v2), BlobStorage, or BlockBlobStorage. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "accountKind")
    private Object accountKind;

    /*
     * The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JsonProperty(value = "encryptedCredential")
    private String encryptedCredential;

    /*
     * The credential reference containing authentication information.
     */
    @JsonProperty(value = "credential")
    private CredentialReference credential;

    /*
     * The type used for authentication. Type: string.
     */
    @JsonProperty(value = "authenticationType")
    private AzureStorageAuthenticationType authenticationType;

    /*
     * Container uri of the Azure Blob Storage resource only support for anonymous access. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "containerUri")
    private Object containerUri;

    /**
     * Creates an instance of AzureBlobStorageLinkedServiceTypeProperties class.
     */
    public AzureBlobStorageLinkedServiceTypeProperties() {
    }

    /**
     * Get the connectionString property: The connection string. It is mutually exclusive with sasUri, serviceEndpoint
     * property. Type: string, SecureString or AzureKeyVaultSecretReference.
     * 
     * @return the connectionString value.
     */
    public Object connectionString() {
        return this.connectionString;
    }

    /**
     * Set the connectionString property: The connection string. It is mutually exclusive with sasUri, serviceEndpoint
     * property. Type: string, SecureString or AzureKeyVaultSecretReference.
     * 
     * @param connectionString the connectionString value to set.
     * @return the AzureBlobStorageLinkedServiceTypeProperties object itself.
     */
    public AzureBlobStorageLinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    /**
     * Get the accountKey property: The Azure key vault secret reference of accountKey in connection string.
     * 
     * @return the accountKey value.
     */
    public AzureKeyVaultSecretReference accountKey() {
        return this.accountKey;
    }

    /**
     * Set the accountKey property: The Azure key vault secret reference of accountKey in connection string.
     * 
     * @param accountKey the accountKey value to set.
     * @return the AzureBlobStorageLinkedServiceTypeProperties object itself.
     */
    public AzureBlobStorageLinkedServiceTypeProperties withAccountKey(AzureKeyVaultSecretReference accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    /**
     * Get the sasUri property: SAS URI of the Azure Blob Storage resource. It is mutually exclusive with
     * connectionString, serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference.
     * 
     * @return the sasUri value.
     */
    public Object sasUri() {
        return this.sasUri;
    }

    /**
     * Set the sasUri property: SAS URI of the Azure Blob Storage resource. It is mutually exclusive with
     * connectionString, serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference.
     * 
     * @param sasUri the sasUri value to set.
     * @return the AzureBlobStorageLinkedServiceTypeProperties object itself.
     */
    public AzureBlobStorageLinkedServiceTypeProperties withSasUri(Object sasUri) {
        this.sasUri = sasUri;
        return this;
    }

    /**
     * Get the sasToken property: The Azure key vault secret reference of sasToken in sas uri.
     * 
     * @return the sasToken value.
     */
    public AzureKeyVaultSecretReference sasToken() {
        return this.sasToken;
    }

    /**
     * Set the sasToken property: The Azure key vault secret reference of sasToken in sas uri.
     * 
     * @param sasToken the sasToken value to set.
     * @return the AzureBlobStorageLinkedServiceTypeProperties object itself.
     */
    public AzureBlobStorageLinkedServiceTypeProperties withSasToken(AzureKeyVaultSecretReference sasToken) {
        this.sasToken = sasToken;
        return this;
    }

    /**
     * Get the serviceEndpoint property: Blob service endpoint of the Azure Blob Storage resource. It is mutually
     * exclusive with connectionString, sasUri property.
     * 
     * @return the serviceEndpoint value.
     */
    public Object serviceEndpoint() {
        return this.serviceEndpoint;
    }

    /**
     * Set the serviceEndpoint property: Blob service endpoint of the Azure Blob Storage resource. It is mutually
     * exclusive with connectionString, sasUri property.
     * 
     * @param serviceEndpoint the serviceEndpoint value to set.
     * @return the AzureBlobStorageLinkedServiceTypeProperties object itself.
     */
    public AzureBlobStorageLinkedServiceTypeProperties withServiceEndpoint(Object serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
        return this;
    }

    /**
     * Get the servicePrincipalId property: The ID of the service principal used to authenticate against Azure SQL Data
     * Warehouse. Type: string (or Expression with resultType string).
     * 
     * @return the servicePrincipalId value.
     */
    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    /**
     * Set the servicePrincipalId property: The ID of the service principal used to authenticate against Azure SQL Data
     * Warehouse. Type: string (or Expression with resultType string).
     * 
     * @param servicePrincipalId the servicePrincipalId value to set.
     * @return the AzureBlobStorageLinkedServiceTypeProperties object itself.
     */
    public AzureBlobStorageLinkedServiceTypeProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    /**
     * Get the servicePrincipalKey property: The key of the service principal used to authenticate against Azure SQL
     * Data Warehouse.
     * 
     * @return the servicePrincipalKey value.
     */
    public SecretBase servicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    /**
     * Set the servicePrincipalKey property: The key of the service principal used to authenticate against Azure SQL
     * Data Warehouse.
     * 
     * @param servicePrincipalKey the servicePrincipalKey value to set.
     * @return the AzureBlobStorageLinkedServiceTypeProperties object itself.
     */
    public AzureBlobStorageLinkedServiceTypeProperties withServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    /**
     * Get the tenant property: The name or ID of the tenant to which the service principal belongs. Type: string (or
     * Expression with resultType string).
     * 
     * @return the tenant value.
     */
    public Object tenant() {
        return this.tenant;
    }

    /**
     * Set the tenant property: The name or ID of the tenant to which the service principal belongs. Type: string (or
     * Expression with resultType string).
     * 
     * @param tenant the tenant value to set.
     * @return the AzureBlobStorageLinkedServiceTypeProperties object itself.
     */
    public AzureBlobStorageLinkedServiceTypeProperties withTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    /**
     * Get the azureCloudType property: Indicates the azure cloud type of the service principle auth. Allowed values are
     * AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type.
     * Type: string (or Expression with resultType string).
     * 
     * @return the azureCloudType value.
     */
    public Object azureCloudType() {
        return this.azureCloudType;
    }

    /**
     * Set the azureCloudType property: Indicates the azure cloud type of the service principle auth. Allowed values are
     * AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type.
     * Type: string (or Expression with resultType string).
     * 
     * @param azureCloudType the azureCloudType value to set.
     * @return the AzureBlobStorageLinkedServiceTypeProperties object itself.
     */
    public AzureBlobStorageLinkedServiceTypeProperties withAzureCloudType(Object azureCloudType) {
        this.azureCloudType = azureCloudType;
        return this;
    }

    /**
     * Get the accountKind property: Specify the kind of your storage account. Allowed values are: Storage (general
     * purpose v1), StorageV2 (general purpose v2), BlobStorage, or BlockBlobStorage. Type: string (or Expression with
     * resultType string).
     * 
     * @return the accountKind value.
     */
    public Object accountKind() {
        return this.accountKind;
    }

    /**
     * Set the accountKind property: Specify the kind of your storage account. Allowed values are: Storage (general
     * purpose v1), StorageV2 (general purpose v2), BlobStorage, or BlockBlobStorage. Type: string (or Expression with
     * resultType string).
     * 
     * @param accountKind the accountKind value to set.
     * @return the AzureBlobStorageLinkedServiceTypeProperties object itself.
     */
    public AzureBlobStorageLinkedServiceTypeProperties withAccountKind(Object accountKind) {
        this.accountKind = accountKind;
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the AzureBlobStorageLinkedServiceTypeProperties object itself.
     */
    public AzureBlobStorageLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    /**
     * Get the credential property: The credential reference containing authentication information.
     * 
     * @return the credential value.
     */
    public CredentialReference credential() {
        return this.credential;
    }

    /**
     * Set the credential property: The credential reference containing authentication information.
     * 
     * @param credential the credential value to set.
     * @return the AzureBlobStorageLinkedServiceTypeProperties object itself.
     */
    public AzureBlobStorageLinkedServiceTypeProperties withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    /**
     * Get the authenticationType property: The type used for authentication. Type: string.
     * 
     * @return the authenticationType value.
     */
    public AzureStorageAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    /**
     * Set the authenticationType property: The type used for authentication. Type: string.
     * 
     * @param authenticationType the authenticationType value to set.
     * @return the AzureBlobStorageLinkedServiceTypeProperties object itself.
     */
    public AzureBlobStorageLinkedServiceTypeProperties
        withAuthenticationType(AzureStorageAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    /**
     * Get the containerUri property: Container uri of the Azure Blob Storage resource only support for anonymous
     * access. Type: string (or Expression with resultType string).
     * 
     * @return the containerUri value.
     */
    public Object containerUri() {
        return this.containerUri;
    }

    /**
     * Set the containerUri property: Container uri of the Azure Blob Storage resource only support for anonymous
     * access. Type: string (or Expression with resultType string).
     * 
     * @param containerUri the containerUri value to set.
     * @return the AzureBlobStorageLinkedServiceTypeProperties object itself.
     */
    public AzureBlobStorageLinkedServiceTypeProperties withContainerUri(Object containerUri) {
        this.containerUri = containerUri;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (accountKey() != null) {
            accountKey().validate();
        }
        if (sasToken() != null) {
            sasToken().validate();
        }
        if (servicePrincipalKey() != null) {
            servicePrincipalKey().validate();
        }
        if (credential() != null) {
            credential().validate();
        }
    }
}
