// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Azure Data Explorer (Kusto) dataset properties.
 */
@Fluent
public final class AzureDataExplorerDatasetTypeProperties {
    /*
     * The table name of the Azure Data Explorer database. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "table")
    private Object table;

    /**
     * Creates an instance of AzureDataExplorerDatasetTypeProperties class.
     */
    public AzureDataExplorerDatasetTypeProperties() {
    }

    /**
     * Get the table property: The table name of the Azure Data Explorer database. Type: string (or Expression with
     * resultType string).
     * 
     * @return the table value.
     */
    public Object table() {
        return this.table;
    }

    /**
     * Set the table property: The table name of the Azure Data Explorer database. Type: string (or Expression with
     * resultType string).
     * 
     * @param table the table value to set.
     * @return the AzureDataExplorerDatasetTypeProperties object itself.
     */
    public AzureDataExplorerDatasetTypeProperties withTable(Object table) {
        this.table = table;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
