// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.datafactory.models.DatasetCompression;
import com.azure.resourcemanager.datafactory.models.DatasetStorageFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Azure Data Lake Store dataset properties.
 */
@Fluent
public final class AzureDataLakeStoreDatasetTypeProperties {
    /*
     * Path to the folder in the Azure Data Lake Store. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "folderPath")
    private Object folderPath;

    /*
     * The name of the file in the Azure Data Lake Store. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "fileName")
    private Object fileName;

    /*
     * The format of the Data Lake Store.
     */
    @JsonProperty(value = "format")
    private DatasetStorageFormat format;

    /*
     * The data compression method used for the item(s) in the Azure Data Lake Store.
     */
    @JsonProperty(value = "compression")
    private DatasetCompression compression;

    /**
     * Creates an instance of AzureDataLakeStoreDatasetTypeProperties class.
     */
    public AzureDataLakeStoreDatasetTypeProperties() {
    }

    /**
     * Get the folderPath property: Path to the folder in the Azure Data Lake Store. Type: string (or Expression with
     * resultType string).
     * 
     * @return the folderPath value.
     */
    public Object folderPath() {
        return this.folderPath;
    }

    /**
     * Set the folderPath property: Path to the folder in the Azure Data Lake Store. Type: string (or Expression with
     * resultType string).
     * 
     * @param folderPath the folderPath value to set.
     * @return the AzureDataLakeStoreDatasetTypeProperties object itself.
     */
    public AzureDataLakeStoreDatasetTypeProperties withFolderPath(Object folderPath) {
        this.folderPath = folderPath;
        return this;
    }

    /**
     * Get the fileName property: The name of the file in the Azure Data Lake Store. Type: string (or Expression with
     * resultType string).
     * 
     * @return the fileName value.
     */
    public Object fileName() {
        return this.fileName;
    }

    /**
     * Set the fileName property: The name of the file in the Azure Data Lake Store. Type: string (or Expression with
     * resultType string).
     * 
     * @param fileName the fileName value to set.
     * @return the AzureDataLakeStoreDatasetTypeProperties object itself.
     */
    public AzureDataLakeStoreDatasetTypeProperties withFileName(Object fileName) {
        this.fileName = fileName;
        return this;
    }

    /**
     * Get the format property: The format of the Data Lake Store.
     * 
     * @return the format value.
     */
    public DatasetStorageFormat format() {
        return this.format;
    }

    /**
     * Set the format property: The format of the Data Lake Store.
     * 
     * @param format the format value to set.
     * @return the AzureDataLakeStoreDatasetTypeProperties object itself.
     */
    public AzureDataLakeStoreDatasetTypeProperties withFormat(DatasetStorageFormat format) {
        this.format = format;
        return this;
    }

    /**
     * Get the compression property: The data compression method used for the item(s) in the Azure Data Lake Store.
     * 
     * @return the compression value.
     */
    public DatasetCompression compression() {
        return this.compression;
    }

    /**
     * Set the compression property: The data compression method used for the item(s) in the Azure Data Lake Store.
     * 
     * @param compression the compression value to set.
     * @return the AzureDataLakeStoreDatasetTypeProperties object itself.
     */
    public AzureDataLakeStoreDatasetTypeProperties withCompression(DatasetCompression compression) {
        this.compression = compression;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (format() != null) {
            format().validate();
        }
        if (compression() != null) {
            compression().validate();
        }
    }
}
