// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Azure ML Studio Web Service linked service properties.
 */
@Fluent
public final class AzureMLLinkedServiceTypeProperties {
    /*
     * The Batch Execution REST URL for an Azure ML Studio Web Service endpoint. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "mlEndpoint", required = true)
    private Object mlEndpoint;

    /*
     * The API key for accessing the Azure ML model endpoint.
     */
    @JsonProperty(value = "apiKey", required = true)
    private SecretBase apiKey;

    /*
     * The Update Resource REST URL for an Azure ML Studio Web Service endpoint. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "updateResourceEndpoint")
    private Object updateResourceEndpoint;

    /*
     * The ID of the service principal used to authenticate against the ARM-based updateResourceEndpoint of an Azure ML Studio web service. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "servicePrincipalId")
    private Object servicePrincipalId;

    /*
     * The key of the service principal used to authenticate against the ARM-based updateResourceEndpoint of an Azure ML Studio web service.
     */
    @JsonProperty(value = "servicePrincipalKey")
    private SecretBase servicePrincipalKey;

    /*
     * The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "tenant")
    private Object tenant;

    /*
     * The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JsonProperty(value = "encryptedCredential")
    private String encryptedCredential;

    /*
     * Type of authentication (Required to specify MSI) used to connect to AzureML. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "authentication")
    private Object authentication;

    /**
     * Creates an instance of AzureMLLinkedServiceTypeProperties class.
     */
    public AzureMLLinkedServiceTypeProperties() {
    }

    /**
     * Get the mlEndpoint property: The Batch Execution REST URL for an Azure ML Studio Web Service endpoint. Type:
     * string (or Expression with resultType string).
     * 
     * @return the mlEndpoint value.
     */
    public Object mlEndpoint() {
        return this.mlEndpoint;
    }

    /**
     * Set the mlEndpoint property: The Batch Execution REST URL for an Azure ML Studio Web Service endpoint. Type:
     * string (or Expression with resultType string).
     * 
     * @param mlEndpoint the mlEndpoint value to set.
     * @return the AzureMLLinkedServiceTypeProperties object itself.
     */
    public AzureMLLinkedServiceTypeProperties withMlEndpoint(Object mlEndpoint) {
        this.mlEndpoint = mlEndpoint;
        return this;
    }

    /**
     * Get the apiKey property: The API key for accessing the Azure ML model endpoint.
     * 
     * @return the apiKey value.
     */
    public SecretBase apiKey() {
        return this.apiKey;
    }

    /**
     * Set the apiKey property: The API key for accessing the Azure ML model endpoint.
     * 
     * @param apiKey the apiKey value to set.
     * @return the AzureMLLinkedServiceTypeProperties object itself.
     */
    public AzureMLLinkedServiceTypeProperties withApiKey(SecretBase apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    /**
     * Get the updateResourceEndpoint property: The Update Resource REST URL for an Azure ML Studio Web Service
     * endpoint. Type: string (or Expression with resultType string).
     * 
     * @return the updateResourceEndpoint value.
     */
    public Object updateResourceEndpoint() {
        return this.updateResourceEndpoint;
    }

    /**
     * Set the updateResourceEndpoint property: The Update Resource REST URL for an Azure ML Studio Web Service
     * endpoint. Type: string (or Expression with resultType string).
     * 
     * @param updateResourceEndpoint the updateResourceEndpoint value to set.
     * @return the AzureMLLinkedServiceTypeProperties object itself.
     */
    public AzureMLLinkedServiceTypeProperties withUpdateResourceEndpoint(Object updateResourceEndpoint) {
        this.updateResourceEndpoint = updateResourceEndpoint;
        return this;
    }

    /**
     * Get the servicePrincipalId property: The ID of the service principal used to authenticate against the ARM-based
     * updateResourceEndpoint of an Azure ML Studio web service. Type: string (or Expression with resultType string).
     * 
     * @return the servicePrincipalId value.
     */
    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    /**
     * Set the servicePrincipalId property: The ID of the service principal used to authenticate against the ARM-based
     * updateResourceEndpoint of an Azure ML Studio web service. Type: string (or Expression with resultType string).
     * 
     * @param servicePrincipalId the servicePrincipalId value to set.
     * @return the AzureMLLinkedServiceTypeProperties object itself.
     */
    public AzureMLLinkedServiceTypeProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    /**
     * Get the servicePrincipalKey property: The key of the service principal used to authenticate against the ARM-based
     * updateResourceEndpoint of an Azure ML Studio web service.
     * 
     * @return the servicePrincipalKey value.
     */
    public SecretBase servicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    /**
     * Set the servicePrincipalKey property: The key of the service principal used to authenticate against the ARM-based
     * updateResourceEndpoint of an Azure ML Studio web service.
     * 
     * @param servicePrincipalKey the servicePrincipalKey value to set.
     * @return the AzureMLLinkedServiceTypeProperties object itself.
     */
    public AzureMLLinkedServiceTypeProperties withServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    /**
     * Get the tenant property: The name or ID of the tenant to which the service principal belongs. Type: string (or
     * Expression with resultType string).
     * 
     * @return the tenant value.
     */
    public Object tenant() {
        return this.tenant;
    }

    /**
     * Set the tenant property: The name or ID of the tenant to which the service principal belongs. Type: string (or
     * Expression with resultType string).
     * 
     * @param tenant the tenant value to set.
     * @return the AzureMLLinkedServiceTypeProperties object itself.
     */
    public AzureMLLinkedServiceTypeProperties withTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the AzureMLLinkedServiceTypeProperties object itself.
     */
    public AzureMLLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    /**
     * Get the authentication property: Type of authentication (Required to specify MSI) used to connect to AzureML.
     * Type: string (or Expression with resultType string).
     * 
     * @return the authentication value.
     */
    public Object authentication() {
        return this.authentication;
    }

    /**
     * Set the authentication property: Type of authentication (Required to specify MSI) used to connect to AzureML.
     * Type: string (or Expression with resultType string).
     * 
     * @param authentication the authentication value to set.
     * @return the AzureMLLinkedServiceTypeProperties object itself.
     */
    public AzureMLLinkedServiceTypeProperties withAuthentication(Object authentication) {
        this.authentication = authentication;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (mlEndpoint() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property mlEndpoint in model AzureMLLinkedServiceTypeProperties"));
        }
        if (apiKey() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property apiKey in model AzureMLLinkedServiceTypeProperties"));
        } else {
            apiKey().validate();
        }
        if (servicePrincipalKey() != null) {
            servicePrincipalKey().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AzureMLLinkedServiceTypeProperties.class);
}
