// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Azure ML Update Resource activity properties.
 */
@Fluent
public final class AzureMLUpdateResourceActivityTypeProperties {
    /*
     * Name of the Trained Model module in the Web Service experiment to be updated. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "trainedModelName", required = true)
    private Object trainedModelName;

    /*
     * Name of Azure Storage linked service holding the .ilearner file that will be uploaded by the update operation.
     */
    @JsonProperty(value = "trainedModelLinkedServiceName", required = true)
    private LinkedServiceReference trainedModelLinkedServiceName;

    /*
     * The relative file path in trainedModelLinkedService to represent the .ilearner file that will be uploaded by the update operation.  Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "trainedModelFilePath", required = true)
    private Object trainedModelFilePath;

    /**
     * Creates an instance of AzureMLUpdateResourceActivityTypeProperties class.
     */
    public AzureMLUpdateResourceActivityTypeProperties() {
    }

    /**
     * Get the trainedModelName property: Name of the Trained Model module in the Web Service experiment to be updated.
     * Type: string (or Expression with resultType string).
     * 
     * @return the trainedModelName value.
     */
    public Object trainedModelName() {
        return this.trainedModelName;
    }

    /**
     * Set the trainedModelName property: Name of the Trained Model module in the Web Service experiment to be updated.
     * Type: string (or Expression with resultType string).
     * 
     * @param trainedModelName the trainedModelName value to set.
     * @return the AzureMLUpdateResourceActivityTypeProperties object itself.
     */
    public AzureMLUpdateResourceActivityTypeProperties withTrainedModelName(Object trainedModelName) {
        this.trainedModelName = trainedModelName;
        return this;
    }

    /**
     * Get the trainedModelLinkedServiceName property: Name of Azure Storage linked service holding the .ilearner file
     * that will be uploaded by the update operation.
     * 
     * @return the trainedModelLinkedServiceName value.
     */
    public LinkedServiceReference trainedModelLinkedServiceName() {
        return this.trainedModelLinkedServiceName;
    }

    /**
     * Set the trainedModelLinkedServiceName property: Name of Azure Storage linked service holding the .ilearner file
     * that will be uploaded by the update operation.
     * 
     * @param trainedModelLinkedServiceName the trainedModelLinkedServiceName value to set.
     * @return the AzureMLUpdateResourceActivityTypeProperties object itself.
     */
    public AzureMLUpdateResourceActivityTypeProperties
        withTrainedModelLinkedServiceName(LinkedServiceReference trainedModelLinkedServiceName) {
        this.trainedModelLinkedServiceName = trainedModelLinkedServiceName;
        return this;
    }

    /**
     * Get the trainedModelFilePath property: The relative file path in trainedModelLinkedService to represent the
     * .ilearner file that will be uploaded by the update operation. Type: string (or Expression with resultType
     * string).
     * 
     * @return the trainedModelFilePath value.
     */
    public Object trainedModelFilePath() {
        return this.trainedModelFilePath;
    }

    /**
     * Set the trainedModelFilePath property: The relative file path in trainedModelLinkedService to represent the
     * .ilearner file that will be uploaded by the update operation. Type: string (or Expression with resultType
     * string).
     * 
     * @param trainedModelFilePath the trainedModelFilePath value to set.
     * @return the AzureMLUpdateResourceActivityTypeProperties object itself.
     */
    public AzureMLUpdateResourceActivityTypeProperties withTrainedModelFilePath(Object trainedModelFilePath) {
        this.trainedModelFilePath = trainedModelFilePath;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (trainedModelName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property trainedModelName in model AzureMLUpdateResourceActivityTypeProperties"));
        }
        if (trainedModelLinkedServiceName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property trainedModelLinkedServiceName in model AzureMLUpdateResourceActivityTypeProperties"));
        } else {
            trainedModelLinkedServiceName().validate();
        }
        if (trainedModelFilePath() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property trainedModelFilePath in model AzureMLUpdateResourceActivityTypeProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AzureMLUpdateResourceActivityTypeProperties.class);
}
