// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Properties specific to this dataset type.
 */
@Fluent
public final class AzureSearchIndexDatasetTypeProperties {
    /*
     * The name of the Azure Search Index. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "indexName", required = true)
    private Object indexName;

    /**
     * Creates an instance of AzureSearchIndexDatasetTypeProperties class.
     */
    public AzureSearchIndexDatasetTypeProperties() {
    }

    /**
     * Get the indexName property: The name of the Azure Search Index. Type: string (or Expression with resultType
     * string).
     * 
     * @return the indexName value.
     */
    public Object indexName() {
        return this.indexName;
    }

    /**
     * Set the indexName property: The name of the Azure Search Index. Type: string (or Expression with resultType
     * string).
     * 
     * @param indexName the indexName value to set.
     * @return the AzureSearchIndexDatasetTypeProperties object itself.
     */
    public AzureSearchIndexDatasetTypeProperties withIndexName(Object indexName) {
        this.indexName = indexName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (indexName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property indexName in model AzureSearchIndexDatasetTypeProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AzureSearchIndexDatasetTypeProperties.class);
}
