// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Windows Azure Search Service linked service properties.
 */
@Fluent
public final class AzureSearchLinkedServiceTypeProperties {
    /*
     * URL for Azure Search service. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "url", required = true)
    private Object url;

    /*
     * Admin Key for Azure Search service
     */
    @JsonProperty(value = "key")
    private SecretBase key;

    /*
     * The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JsonProperty(value = "encryptedCredential")
    private String encryptedCredential;

    /**
     * Creates an instance of AzureSearchLinkedServiceTypeProperties class.
     */
    public AzureSearchLinkedServiceTypeProperties() {
    }

    /**
     * Get the url property: URL for Azure Search service. Type: string (or Expression with resultType string).
     * 
     * @return the url value.
     */
    public Object url() {
        return this.url;
    }

    /**
     * Set the url property: URL for Azure Search service. Type: string (or Expression with resultType string).
     * 
     * @param url the url value to set.
     * @return the AzureSearchLinkedServiceTypeProperties object itself.
     */
    public AzureSearchLinkedServiceTypeProperties withUrl(Object url) {
        this.url = url;
        return this;
    }

    /**
     * Get the key property: Admin Key for Azure Search service.
     * 
     * @return the key value.
     */
    public SecretBase key() {
        return this.key;
    }

    /**
     * Set the key property: Admin Key for Azure Search service.
     * 
     * @param key the key value to set.
     * @return the AzureSearchLinkedServiceTypeProperties object itself.
     */
    public AzureSearchLinkedServiceTypeProperties withKey(SecretBase key) {
        this.key = key;
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the AzureSearchLinkedServiceTypeProperties object itself.
     */
    public AzureSearchLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (url() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property url in model AzureSearchLinkedServiceTypeProperties"));
        }
        if (key() != null) {
            key().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AzureSearchLinkedServiceTypeProperties.class);
}
