// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.DatasetCompression;
import com.azure.resourcemanager.datafactory.models.DatasetLocation;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Binary dataset properties.
 */
@Fluent
public final class BinaryDatasetTypeProperties {
    /*
     * The location of the Binary storage.
     */
    @JsonProperty(value = "location", required = true)
    private DatasetLocation location;

    /*
     * The data compression method used for the binary dataset.
     */
    @JsonProperty(value = "compression")
    private DatasetCompression compression;

    /**
     * Creates an instance of BinaryDatasetTypeProperties class.
     */
    public BinaryDatasetTypeProperties() {
    }

    /**
     * Get the location property: The location of the Binary storage.
     * 
     * @return the location value.
     */
    public DatasetLocation location() {
        return this.location;
    }

    /**
     * Set the location property: The location of the Binary storage.
     * 
     * @param location the location value to set.
     * @return the BinaryDatasetTypeProperties object itself.
     */
    public BinaryDatasetTypeProperties withLocation(DatasetLocation location) {
        this.location = location;
        return this;
    }

    /**
     * Get the compression property: The data compression method used for the binary dataset.
     * 
     * @return the compression value.
     */
    public DatasetCompression compression() {
        return this.compression;
    }

    /**
     * Set the compression property: The data compression method used for the binary dataset.
     * 
     * @param compression the compression value to set.
     * @return the BinaryDatasetTypeProperties object itself.
     */
    public BinaryDatasetTypeProperties withCompression(DatasetCompression compression) {
        this.compression = compression;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (location() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property location in model BinaryDatasetTypeProperties"));
        } else {
            location().validate();
        }
        if (compression() != null) {
            compression().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(BinaryDatasetTypeProperties.class);
}
