// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.ChangeDataCaptureFolder;
import com.azure.resourcemanager.datafactory.models.MapperPolicy;
import com.azure.resourcemanager.datafactory.models.MapperSourceConnectionsInfo;
import com.azure.resourcemanager.datafactory.models.MapperTargetConnectionsInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * A Azure Data Factory object which automatically detects data changes at the source and then sends the updated data to
 * the destination.
 */
@Fluent
public final class ChangeDataCapture {
    /*
     * The folder that this CDC is in. If not specified, CDC will appear at the root level.
     */
    @JsonProperty(value = "folder")
    private ChangeDataCaptureFolder folder;

    /*
     * The description of the change data capture.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * List of sources connections that can be used as sources in the CDC.
     */
    @JsonProperty(value = "sourceConnectionsInfo", required = true)
    private List<MapperSourceConnectionsInfo> sourceConnectionsInfo;

    /*
     * List of target connections that can be used as sources in the CDC.
     */
    @JsonProperty(value = "targetConnectionsInfo", required = true)
    private List<MapperTargetConnectionsInfo> targetConnectionsInfo;

    /*
     * CDC policy
     */
    @JsonProperty(value = "policy", required = true)
    private MapperPolicy policy;

    /*
     * A boolean to determine if the vnet configuration needs to be overwritten.
     */
    @JsonProperty(value = "allowVNetOverride")
    private Boolean allowVNetOverride;

    /*
     * Status of the CDC as to if it is running or stopped.
     */
    @JsonProperty(value = "status")
    private String status;

    /**
     * Creates an instance of ChangeDataCapture class.
     */
    public ChangeDataCapture() {
    }

    /**
     * Get the folder property: The folder that this CDC is in. If not specified, CDC will appear at the root level.
     * 
     * @return the folder value.
     */
    public ChangeDataCaptureFolder folder() {
        return this.folder;
    }

    /**
     * Set the folder property: The folder that this CDC is in. If not specified, CDC will appear at the root level.
     * 
     * @param folder the folder value to set.
     * @return the ChangeDataCapture object itself.
     */
    public ChangeDataCapture withFolder(ChangeDataCaptureFolder folder) {
        this.folder = folder;
        return this;
    }

    /**
     * Get the description property: The description of the change data capture.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description of the change data capture.
     * 
     * @param description the description value to set.
     * @return the ChangeDataCapture object itself.
     */
    public ChangeDataCapture withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the sourceConnectionsInfo property: List of sources connections that can be used as sources in the CDC.
     * 
     * @return the sourceConnectionsInfo value.
     */
    public List<MapperSourceConnectionsInfo> sourceConnectionsInfo() {
        return this.sourceConnectionsInfo;
    }

    /**
     * Set the sourceConnectionsInfo property: List of sources connections that can be used as sources in the CDC.
     * 
     * @param sourceConnectionsInfo the sourceConnectionsInfo value to set.
     * @return the ChangeDataCapture object itself.
     */
    public ChangeDataCapture withSourceConnectionsInfo(List<MapperSourceConnectionsInfo> sourceConnectionsInfo) {
        this.sourceConnectionsInfo = sourceConnectionsInfo;
        return this;
    }

    /**
     * Get the targetConnectionsInfo property: List of target connections that can be used as sources in the CDC.
     * 
     * @return the targetConnectionsInfo value.
     */
    public List<MapperTargetConnectionsInfo> targetConnectionsInfo() {
        return this.targetConnectionsInfo;
    }

    /**
     * Set the targetConnectionsInfo property: List of target connections that can be used as sources in the CDC.
     * 
     * @param targetConnectionsInfo the targetConnectionsInfo value to set.
     * @return the ChangeDataCapture object itself.
     */
    public ChangeDataCapture withTargetConnectionsInfo(List<MapperTargetConnectionsInfo> targetConnectionsInfo) {
        this.targetConnectionsInfo = targetConnectionsInfo;
        return this;
    }

    /**
     * Get the policy property: CDC policy.
     * 
     * @return the policy value.
     */
    public MapperPolicy policy() {
        return this.policy;
    }

    /**
     * Set the policy property: CDC policy.
     * 
     * @param policy the policy value to set.
     * @return the ChangeDataCapture object itself.
     */
    public ChangeDataCapture withPolicy(MapperPolicy policy) {
        this.policy = policy;
        return this;
    }

    /**
     * Get the allowVNetOverride property: A boolean to determine if the vnet configuration needs to be overwritten.
     * 
     * @return the allowVNetOverride value.
     */
    public Boolean allowVNetOverride() {
        return this.allowVNetOverride;
    }

    /**
     * Set the allowVNetOverride property: A boolean to determine if the vnet configuration needs to be overwritten.
     * 
     * @param allowVNetOverride the allowVNetOverride value to set.
     * @return the ChangeDataCapture object itself.
     */
    public ChangeDataCapture withAllowVNetOverride(Boolean allowVNetOverride) {
        this.allowVNetOverride = allowVNetOverride;
        return this;
    }

    /**
     * Get the status property: Status of the CDC as to if it is running or stopped.
     * 
     * @return the status value.
     */
    public String status() {
        return this.status;
    }

    /**
     * Set the status property: Status of the CDC as to if it is running or stopped.
     * 
     * @param status the status value to set.
     * @return the ChangeDataCapture object itself.
     */
    public ChangeDataCapture withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (folder() != null) {
            folder().validate();
        }
        if (sourceConnectionsInfo() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property sourceConnectionsInfo in model ChangeDataCapture"));
        } else {
            sourceConnectionsInfo().forEach(e -> e.validate());
        }
        if (targetConnectionsInfo() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property targetConnectionsInfo in model ChangeDataCapture"));
        } else {
            targetConnectionsInfo().forEach(e -> e.validate());
        }
        if (policy() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property policy in model ChangeDataCapture"));
        } else {
            policy().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ChangeDataCapture.class);
}
