// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Cmdkey command custom setup type properties.
 */
@Fluent
public final class CmdkeySetupTypeProperties {
    /*
     * The server name of data source access. Type: string.
     */
    @JsonProperty(value = "targetName", required = true)
    private Object targetName;

    /*
     * The user name of data source access. Type: string.
     */
    @JsonProperty(value = "userName", required = true)
    private Object username;

    /*
     * The password of data source access.
     */
    @JsonProperty(value = "password", required = true)
    private SecretBase password;

    /**
     * Creates an instance of CmdkeySetupTypeProperties class.
     */
    public CmdkeySetupTypeProperties() {
    }

    /**
     * Get the targetName property: The server name of data source access. Type: string.
     * 
     * @return the targetName value.
     */
    public Object targetName() {
        return this.targetName;
    }

    /**
     * Set the targetName property: The server name of data source access. Type: string.
     * 
     * @param targetName the targetName value to set.
     * @return the CmdkeySetupTypeProperties object itself.
     */
    public CmdkeySetupTypeProperties withTargetName(Object targetName) {
        this.targetName = targetName;
        return this;
    }

    /**
     * Get the username property: The user name of data source access. Type: string.
     * 
     * @return the username value.
     */
    public Object username() {
        return this.username;
    }

    /**
     * Set the username property: The user name of data source access. Type: string.
     * 
     * @param username the username value to set.
     * @return the CmdkeySetupTypeProperties object itself.
     */
    public CmdkeySetupTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    /**
     * Get the password property: The password of data source access.
     * 
     * @return the password value.
     */
    public SecretBase password() {
        return this.password;
    }

    /**
     * Set the password property: The password of data source access.
     * 
     * @param password the password value to set.
     * @return the CmdkeySetupTypeProperties object itself.
     */
    public CmdkeySetupTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (targetName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property targetName in model CmdkeySetupTypeProperties"));
        }
        if (username() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property username in model CmdkeySetupTypeProperties"));
        }
        if (password() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property password in model CmdkeySetupTypeProperties"));
        } else {
            password().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CmdkeySetupTypeProperties.class);
}
