// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.datafactory.models.CosmosDbConnectionMode;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * CosmosDB linked service properties.
 */
@Fluent
public final class CosmosDbLinkedServiceTypeProperties {
    /*
     * The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JsonProperty(value = "connectionString")
    private Object connectionString;

    /*
     * The endpoint of the Azure CosmosDB account. Type: string (or Expression with resultType string)
     */
    @JsonProperty(value = "accountEndpoint")
    private Object accountEndpoint;

    /*
     * The name of the database. Type: string (or Expression with resultType string)
     */
    @JsonProperty(value = "database")
    private Object database;

    /*
     * The account key of the Azure CosmosDB account. Type: SecureString or AzureKeyVaultSecretReference.
     */
    @JsonProperty(value = "accountKey")
    private SecretBase accountKey;

    /*
     * The client ID of the application in Azure Active Directory used for Server-To-Server authentication. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "servicePrincipalId")
    private Object servicePrincipalId;

    /*
     * The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert' for certificate. Type: string.
     */
    @JsonProperty(value = "servicePrincipalCredentialType")
    private Object servicePrincipalCredentialType;

    /*
     * The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only be AzureKeyVaultSecretReference.
     */
    @JsonProperty(value = "servicePrincipalCredential")
    private SecretBase servicePrincipalCredential;

    /*
     * The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "tenant")
    private Object tenant;

    /*
     * Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "azureCloudType")
    private Object azureCloudType;

    /*
     * The connection mode used to access CosmosDB account. Type: string.
     */
    @JsonProperty(value = "connectionMode")
    private CosmosDbConnectionMode connectionMode;

    /*
     * The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JsonProperty(value = "encryptedCredential")
    private String encryptedCredential;

    /*
     * The credential reference containing authentication information.
     */
    @JsonProperty(value = "credential")
    private CredentialReference credential;

    /**
     * Creates an instance of CosmosDbLinkedServiceTypeProperties class.
     */
    public CosmosDbLinkedServiceTypeProperties() {
    }

    /**
     * Get the connectionString property: The connection string. Type: string, SecureString or
     * AzureKeyVaultSecretReference.
     * 
     * @return the connectionString value.
     */
    public Object connectionString() {
        return this.connectionString;
    }

    /**
     * Set the connectionString property: The connection string. Type: string, SecureString or
     * AzureKeyVaultSecretReference.
     * 
     * @param connectionString the connectionString value to set.
     * @return the CosmosDbLinkedServiceTypeProperties object itself.
     */
    public CosmosDbLinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    /**
     * Get the accountEndpoint property: The endpoint of the Azure CosmosDB account. Type: string (or Expression with
     * resultType string).
     * 
     * @return the accountEndpoint value.
     */
    public Object accountEndpoint() {
        return this.accountEndpoint;
    }

    /**
     * Set the accountEndpoint property: The endpoint of the Azure CosmosDB account. Type: string (or Expression with
     * resultType string).
     * 
     * @param accountEndpoint the accountEndpoint value to set.
     * @return the CosmosDbLinkedServiceTypeProperties object itself.
     */
    public CosmosDbLinkedServiceTypeProperties withAccountEndpoint(Object accountEndpoint) {
        this.accountEndpoint = accountEndpoint;
        return this;
    }

    /**
     * Get the database property: The name of the database. Type: string (or Expression with resultType string).
     * 
     * @return the database value.
     */
    public Object database() {
        return this.database;
    }

    /**
     * Set the database property: The name of the database. Type: string (or Expression with resultType string).
     * 
     * @param database the database value to set.
     * @return the CosmosDbLinkedServiceTypeProperties object itself.
     */
    public CosmosDbLinkedServiceTypeProperties withDatabase(Object database) {
        this.database = database;
        return this;
    }

    /**
     * Get the accountKey property: The account key of the Azure CosmosDB account. Type: SecureString or
     * AzureKeyVaultSecretReference.
     * 
     * @return the accountKey value.
     */
    public SecretBase accountKey() {
        return this.accountKey;
    }

    /**
     * Set the accountKey property: The account key of the Azure CosmosDB account. Type: SecureString or
     * AzureKeyVaultSecretReference.
     * 
     * @param accountKey the accountKey value to set.
     * @return the CosmosDbLinkedServiceTypeProperties object itself.
     */
    public CosmosDbLinkedServiceTypeProperties withAccountKey(SecretBase accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    /**
     * Get the servicePrincipalId property: The client ID of the application in Azure Active Directory used for
     * Server-To-Server authentication. Type: string (or Expression with resultType string).
     * 
     * @return the servicePrincipalId value.
     */
    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    /**
     * Set the servicePrincipalId property: The client ID of the application in Azure Active Directory used for
     * Server-To-Server authentication. Type: string (or Expression with resultType string).
     * 
     * @param servicePrincipalId the servicePrincipalId value to set.
     * @return the CosmosDbLinkedServiceTypeProperties object itself.
     */
    public CosmosDbLinkedServiceTypeProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    /**
     * Get the servicePrincipalCredentialType property: The service principal credential type to use in Server-To-Server
     * authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert' for certificate. Type: string.
     * 
     * @return the servicePrincipalCredentialType value.
     */
    public Object servicePrincipalCredentialType() {
        return this.servicePrincipalCredentialType;
    }

    /**
     * Set the servicePrincipalCredentialType property: The service principal credential type to use in Server-To-Server
     * authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert' for certificate. Type: string.
     * 
     * @param servicePrincipalCredentialType the servicePrincipalCredentialType value to set.
     * @return the CosmosDbLinkedServiceTypeProperties object itself.
     */
    public CosmosDbLinkedServiceTypeProperties
        withServicePrincipalCredentialType(Object servicePrincipalCredentialType) {
        this.servicePrincipalCredentialType = servicePrincipalCredentialType;
        return this;
    }

    /**
     * Get the servicePrincipalCredential property: The credential of the service principal object in Azure Active
     * Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be
     * SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert',
     * servicePrincipalCredential can only be AzureKeyVaultSecretReference.
     * 
     * @return the servicePrincipalCredential value.
     */
    public SecretBase servicePrincipalCredential() {
        return this.servicePrincipalCredential;
    }

    /**
     * Set the servicePrincipalCredential property: The credential of the service principal object in Azure Active
     * Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be
     * SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert',
     * servicePrincipalCredential can only be AzureKeyVaultSecretReference.
     * 
     * @param servicePrincipalCredential the servicePrincipalCredential value to set.
     * @return the CosmosDbLinkedServiceTypeProperties object itself.
     */
    public CosmosDbLinkedServiceTypeProperties withServicePrincipalCredential(SecretBase servicePrincipalCredential) {
        this.servicePrincipalCredential = servicePrincipalCredential;
        return this;
    }

    /**
     * Get the tenant property: The name or ID of the tenant to which the service principal belongs. Type: string (or
     * Expression with resultType string).
     * 
     * @return the tenant value.
     */
    public Object tenant() {
        return this.tenant;
    }

    /**
     * Set the tenant property: The name or ID of the tenant to which the service principal belongs. Type: string (or
     * Expression with resultType string).
     * 
     * @param tenant the tenant value to set.
     * @return the CosmosDbLinkedServiceTypeProperties object itself.
     */
    public CosmosDbLinkedServiceTypeProperties withTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    /**
     * Get the azureCloudType property: Indicates the azure cloud type of the service principle auth. Allowed values are
     * AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type.
     * Type: string (or Expression with resultType string).
     * 
     * @return the azureCloudType value.
     */
    public Object azureCloudType() {
        return this.azureCloudType;
    }

    /**
     * Set the azureCloudType property: Indicates the azure cloud type of the service principle auth. Allowed values are
     * AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type.
     * Type: string (or Expression with resultType string).
     * 
     * @param azureCloudType the azureCloudType value to set.
     * @return the CosmosDbLinkedServiceTypeProperties object itself.
     */
    public CosmosDbLinkedServiceTypeProperties withAzureCloudType(Object azureCloudType) {
        this.azureCloudType = azureCloudType;
        return this;
    }

    /**
     * Get the connectionMode property: The connection mode used to access CosmosDB account. Type: string.
     * 
     * @return the connectionMode value.
     */
    public CosmosDbConnectionMode connectionMode() {
        return this.connectionMode;
    }

    /**
     * Set the connectionMode property: The connection mode used to access CosmosDB account. Type: string.
     * 
     * @param connectionMode the connectionMode value to set.
     * @return the CosmosDbLinkedServiceTypeProperties object itself.
     */
    public CosmosDbLinkedServiceTypeProperties withConnectionMode(CosmosDbConnectionMode connectionMode) {
        this.connectionMode = connectionMode;
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the CosmosDbLinkedServiceTypeProperties object itself.
     */
    public CosmosDbLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    /**
     * Get the credential property: The credential reference containing authentication information.
     * 
     * @return the credential value.
     */
    public CredentialReference credential() {
        return this.credential;
    }

    /**
     * Set the credential property: The credential reference containing authentication information.
     * 
     * @param credential the credential value to set.
     * @return the CosmosDbLinkedServiceTypeProperties object itself.
     */
    public CosmosDbLinkedServiceTypeProperties withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (accountKey() != null) {
            accountKey().validate();
        }
        if (servicePrincipalCredential() != null) {
            servicePrincipalCredential().validate();
        }
        if (credential() != null) {
            credential().validate();
        }
    }
}
