// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * CosmosDB (MongoDB API) linked service properties.
 */
@Fluent
public final class CosmosDbMongoDbApiLinkedServiceTypeProperties {
    /*
     * Whether the CosmosDB (MongoDB API) server version is higher than 3.2. The default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JsonProperty(value = "isServerVersionAbove32")
    private Object isServerVersionAbove32;

    /*
     * The CosmosDB (MongoDB API) connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JsonProperty(value = "connectionString", required = true)
    private Object connectionString;

    /*
     * The name of the CosmosDB (MongoDB API) database that you want to access. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "database", required = true)
    private Object database;

    /**
     * Creates an instance of CosmosDbMongoDbApiLinkedServiceTypeProperties class.
     */
    public CosmosDbMongoDbApiLinkedServiceTypeProperties() {
    }

    /**
     * Get the isServerVersionAbove32 property: Whether the CosmosDB (MongoDB API) server version is higher than 3.2.
     * The default value is false. Type: boolean (or Expression with resultType boolean).
     * 
     * @return the isServerVersionAbove32 value.
     */
    public Object isServerVersionAbove32() {
        return this.isServerVersionAbove32;
    }

    /**
     * Set the isServerVersionAbove32 property: Whether the CosmosDB (MongoDB API) server version is higher than 3.2.
     * The default value is false. Type: boolean (or Expression with resultType boolean).
     * 
     * @param isServerVersionAbove32 the isServerVersionAbove32 value to set.
     * @return the CosmosDbMongoDbApiLinkedServiceTypeProperties object itself.
     */
    public CosmosDbMongoDbApiLinkedServiceTypeProperties withIsServerVersionAbove32(Object isServerVersionAbove32) {
        this.isServerVersionAbove32 = isServerVersionAbove32;
        return this;
    }

    /**
     * Get the connectionString property: The CosmosDB (MongoDB API) connection string. Type: string, SecureString or
     * AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
     * 
     * @return the connectionString value.
     */
    public Object connectionString() {
        return this.connectionString;
    }

    /**
     * Set the connectionString property: The CosmosDB (MongoDB API) connection string. Type: string, SecureString or
     * AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
     * 
     * @param connectionString the connectionString value to set.
     * @return the CosmosDbMongoDbApiLinkedServiceTypeProperties object itself.
     */
    public CosmosDbMongoDbApiLinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    /**
     * Get the database property: The name of the CosmosDB (MongoDB API) database that you want to access. Type: string
     * (or Expression with resultType string).
     * 
     * @return the database value.
     */
    public Object database() {
        return this.database;
    }

    /**
     * Set the database property: The name of the CosmosDB (MongoDB API) database that you want to access. Type: string
     * (or Expression with resultType string).
     * 
     * @param database the database value to set.
     * @return the CosmosDbMongoDbApiLinkedServiceTypeProperties object itself.
     */
    public CosmosDbMongoDbApiLinkedServiceTypeProperties withDatabase(Object database) {
        this.database = database;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (connectionString() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property connectionString in model CosmosDbMongoDbApiLinkedServiceTypeProperties"));
        }
        if (database() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property database in model CosmosDbMongoDbApiLinkedServiceTypeProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CosmosDbMongoDbApiLinkedServiceTypeProperties.class);
}
