// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.CustomActivityReferenceObject;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * Custom activity properties.
 */
@Fluent
public final class CustomActivityTypeProperties {
    /*
     * Command for custom activity Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "command", required = true)
    private Object command;

    /*
     * Resource linked service reference.
     */
    @JsonProperty(value = "resourceLinkedService")
    private LinkedServiceReference resourceLinkedService;

    /*
     * Folder path for resource files Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "folderPath")
    private Object folderPath;

    /*
     * Reference objects
     */
    @JsonProperty(value = "referenceObjects")
    private CustomActivityReferenceObject referenceObjects;

    /*
     * User defined property bag. There is no restriction on the keys or values that can be used. The user specified custom activity has the full responsibility to consume and interpret the content defined.
     */
    @JsonProperty(value = "extendedProperties")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, Object> extendedProperties;

    /*
     * The retention time for the files submitted for custom activity. Type: double (or Expression with resultType double).
     */
    @JsonProperty(value = "retentionTimeInDays")
    private Object retentionTimeInDays;

    /*
     * Elevation level and scope for the user, default is nonadmin task. Type: string (or Expression with resultType double).
     */
    @JsonProperty(value = "autoUserSpecification")
    private Object autoUserSpecification;

    /**
     * Creates an instance of CustomActivityTypeProperties class.
     */
    public CustomActivityTypeProperties() {
    }

    /**
     * Get the command property: Command for custom activity Type: string (or Expression with resultType string).
     * 
     * @return the command value.
     */
    public Object command() {
        return this.command;
    }

    /**
     * Set the command property: Command for custom activity Type: string (or Expression with resultType string).
     * 
     * @param command the command value to set.
     * @return the CustomActivityTypeProperties object itself.
     */
    public CustomActivityTypeProperties withCommand(Object command) {
        this.command = command;
        return this;
    }

    /**
     * Get the resourceLinkedService property: Resource linked service reference.
     * 
     * @return the resourceLinkedService value.
     */
    public LinkedServiceReference resourceLinkedService() {
        return this.resourceLinkedService;
    }

    /**
     * Set the resourceLinkedService property: Resource linked service reference.
     * 
     * @param resourceLinkedService the resourceLinkedService value to set.
     * @return the CustomActivityTypeProperties object itself.
     */
    public CustomActivityTypeProperties withResourceLinkedService(LinkedServiceReference resourceLinkedService) {
        this.resourceLinkedService = resourceLinkedService;
        return this;
    }

    /**
     * Get the folderPath property: Folder path for resource files Type: string (or Expression with resultType string).
     * 
     * @return the folderPath value.
     */
    public Object folderPath() {
        return this.folderPath;
    }

    /**
     * Set the folderPath property: Folder path for resource files Type: string (or Expression with resultType string).
     * 
     * @param folderPath the folderPath value to set.
     * @return the CustomActivityTypeProperties object itself.
     */
    public CustomActivityTypeProperties withFolderPath(Object folderPath) {
        this.folderPath = folderPath;
        return this;
    }

    /**
     * Get the referenceObjects property: Reference objects.
     * 
     * @return the referenceObjects value.
     */
    public CustomActivityReferenceObject referenceObjects() {
        return this.referenceObjects;
    }

    /**
     * Set the referenceObjects property: Reference objects.
     * 
     * @param referenceObjects the referenceObjects value to set.
     * @return the CustomActivityTypeProperties object itself.
     */
    public CustomActivityTypeProperties withReferenceObjects(CustomActivityReferenceObject referenceObjects) {
        this.referenceObjects = referenceObjects;
        return this;
    }

    /**
     * Get the extendedProperties property: User defined property bag. There is no restriction on the keys or values
     * that can be used. The user specified custom activity has the full responsibility to consume and interpret the
     * content defined.
     * 
     * @return the extendedProperties value.
     */
    public Map<String, Object> extendedProperties() {
        return this.extendedProperties;
    }

    /**
     * Set the extendedProperties property: User defined property bag. There is no restriction on the keys or values
     * that can be used. The user specified custom activity has the full responsibility to consume and interpret the
     * content defined.
     * 
     * @param extendedProperties the extendedProperties value to set.
     * @return the CustomActivityTypeProperties object itself.
     */
    public CustomActivityTypeProperties withExtendedProperties(Map<String, Object> extendedProperties) {
        this.extendedProperties = extendedProperties;
        return this;
    }

    /**
     * Get the retentionTimeInDays property: The retention time for the files submitted for custom activity. Type:
     * double (or Expression with resultType double).
     * 
     * @return the retentionTimeInDays value.
     */
    public Object retentionTimeInDays() {
        return this.retentionTimeInDays;
    }

    /**
     * Set the retentionTimeInDays property: The retention time for the files submitted for custom activity. Type:
     * double (or Expression with resultType double).
     * 
     * @param retentionTimeInDays the retentionTimeInDays value to set.
     * @return the CustomActivityTypeProperties object itself.
     */
    public CustomActivityTypeProperties withRetentionTimeInDays(Object retentionTimeInDays) {
        this.retentionTimeInDays = retentionTimeInDays;
        return this;
    }

    /**
     * Get the autoUserSpecification property: Elevation level and scope for the user, default is nonadmin task. Type:
     * string (or Expression with resultType double).
     * 
     * @return the autoUserSpecification value.
     */
    public Object autoUserSpecification() {
        return this.autoUserSpecification;
    }

    /**
     * Set the autoUserSpecification property: Elevation level and scope for the user, default is nonadmin task. Type:
     * string (or Expression with resultType double).
     * 
     * @param autoUserSpecification the autoUserSpecification value to set.
     * @return the CustomActivityTypeProperties object itself.
     */
    public CustomActivityTypeProperties withAutoUserSpecification(Object autoUserSpecification) {
        this.autoUserSpecification = autoUserSpecification;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (command() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property command in model CustomActivityTypeProperties"));
        }
        if (resourceLinkedService() != null) {
            resourceLinkedService().validate();
        }
        if (referenceObjects() != null) {
            referenceObjects().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CustomActivityTypeProperties.class);
}
