// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Custom Events Trigger properties.
 */
@Fluent
public final class CustomEventsTriggerTypeProperties {
    /*
     * The event subject must begin with the pattern provided for trigger to fire. At least one of these must be provided: subjectBeginsWith, subjectEndsWith.
     */
    @JsonProperty(value = "subjectBeginsWith")
    private String subjectBeginsWith;

    /*
     * The event subject must end with the pattern provided for trigger to fire. At least one of these must be provided: subjectBeginsWith, subjectEndsWith.
     */
    @JsonProperty(value = "subjectEndsWith")
    private String subjectEndsWith;

    /*
     * The list of event types that cause this trigger to fire.
     */
    @JsonProperty(value = "events", required = true)
    private List<Object> events;

    /*
     * The ARM resource ID of the Azure Event Grid Topic.
     */
    @JsonProperty(value = "scope", required = true)
    private String scope;

    /**
     * Creates an instance of CustomEventsTriggerTypeProperties class.
     */
    public CustomEventsTriggerTypeProperties() {
    }

    /**
     * Get the subjectBeginsWith property: The event subject must begin with the pattern provided for trigger to fire.
     * At least one of these must be provided: subjectBeginsWith, subjectEndsWith.
     * 
     * @return the subjectBeginsWith value.
     */
    public String subjectBeginsWith() {
        return this.subjectBeginsWith;
    }

    /**
     * Set the subjectBeginsWith property: The event subject must begin with the pattern provided for trigger to fire.
     * At least one of these must be provided: subjectBeginsWith, subjectEndsWith.
     * 
     * @param subjectBeginsWith the subjectBeginsWith value to set.
     * @return the CustomEventsTriggerTypeProperties object itself.
     */
    public CustomEventsTriggerTypeProperties withSubjectBeginsWith(String subjectBeginsWith) {
        this.subjectBeginsWith = subjectBeginsWith;
        return this;
    }

    /**
     * Get the subjectEndsWith property: The event subject must end with the pattern provided for trigger to fire. At
     * least one of these must be provided: subjectBeginsWith, subjectEndsWith.
     * 
     * @return the subjectEndsWith value.
     */
    public String subjectEndsWith() {
        return this.subjectEndsWith;
    }

    /**
     * Set the subjectEndsWith property: The event subject must end with the pattern provided for trigger to fire. At
     * least one of these must be provided: subjectBeginsWith, subjectEndsWith.
     * 
     * @param subjectEndsWith the subjectEndsWith value to set.
     * @return the CustomEventsTriggerTypeProperties object itself.
     */
    public CustomEventsTriggerTypeProperties withSubjectEndsWith(String subjectEndsWith) {
        this.subjectEndsWith = subjectEndsWith;
        return this;
    }

    /**
     * Get the events property: The list of event types that cause this trigger to fire.
     * 
     * @return the events value.
     */
    public List<Object> events() {
        return this.events;
    }

    /**
     * Set the events property: The list of event types that cause this trigger to fire.
     * 
     * @param events the events value to set.
     * @return the CustomEventsTriggerTypeProperties object itself.
     */
    public CustomEventsTriggerTypeProperties withEvents(List<Object> events) {
        this.events = events;
        return this;
    }

    /**
     * Get the scope property: The ARM resource ID of the Azure Event Grid Topic.
     * 
     * @return the scope value.
     */
    public String scope() {
        return this.scope;
    }

    /**
     * Set the scope property: The ARM resource ID of the Azure Event Grid Topic.
     * 
     * @param scope the scope value to set.
     * @return the CustomEventsTriggerTypeProperties object itself.
     */
    public CustomEventsTriggerTypeProperties withScope(String scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (events() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property events in model CustomEventsTriggerTypeProperties"));
        }
        if (scope() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property scope in model CustomEventsTriggerTypeProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CustomEventsTriggerTypeProperties.class);
}
