// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Response body structure of data flow result for data preview, statistics or expression preview.
 */
@Fluent
public final class DataFlowDebugCommandResponseInner {
    /*
     * The run status of data preview, statistics or expression preview.
     */
    @JsonProperty(value = "status")
    private String status;

    /*
     * The result data of data preview, statistics or expression preview.
     */
    @JsonProperty(value = "data")
    private String data;

    /**
     * Creates an instance of DataFlowDebugCommandResponseInner class.
     */
    public DataFlowDebugCommandResponseInner() {
    }

    /**
     * Get the status property: The run status of data preview, statistics or expression preview.
     * 
     * @return the status value.
     */
    public String status() {
        return this.status;
    }

    /**
     * Set the status property: The run status of data preview, statistics or expression preview.
     * 
     * @param status the status value to set.
     * @return the DataFlowDebugCommandResponseInner object itself.
     */
    public DataFlowDebugCommandResponseInner withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
     * Get the data property: The result data of data preview, statistics or expression preview.
     * 
     * @return the data value.
     */
    public String data() {
        return this.data;
    }

    /**
     * Set the data property: The result data of data preview, statistics or expression preview.
     * 
     * @param data the data value to set.
     * @return the DataFlowDebugCommandResponseInner object itself.
     */
    public DataFlowDebugCommandResponseInner withData(String data) {
        this.data = data;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
