// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * DataLakeAnalyticsU-SQL activity properties.
 */
@Fluent
public final class DataLakeAnalyticsUsqlActivityTypeProperties {
    /*
     * Case-sensitive path to folder that contains the U-SQL script. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "scriptPath", required = true)
    private Object scriptPath;

    /*
     * Script linked service reference.
     */
    @JsonProperty(value = "scriptLinkedService", required = true)
    private LinkedServiceReference scriptLinkedService;

    /*
     * The maximum number of nodes simultaneously used to run the job. Default value is 1. Type: integer (or Expression with resultType integer), minimum: 1.
     */
    @JsonProperty(value = "degreeOfParallelism")
    private Object degreeOfParallelism;

    /*
     * Determines which jobs out of all that are queued should be selected to run first. The lower the number, the higher the priority. Default value is 1000. Type: integer (or Expression with resultType integer), minimum: 1.
     */
    @JsonProperty(value = "priority")
    private Object priority;

    /*
     * Parameters for U-SQL job request.
     */
    @JsonProperty(value = "parameters")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, Object> parameters;

    /*
     * Runtime version of the U-SQL engine to use. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "runtimeVersion")
    private Object runtimeVersion;

    /*
     * Compilation mode of U-SQL. Must be one of these values : Semantic, Full and SingleBox. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "compilationMode")
    private Object compilationMode;

    /**
     * Creates an instance of DataLakeAnalyticsUsqlActivityTypeProperties class.
     */
    public DataLakeAnalyticsUsqlActivityTypeProperties() {
    }

    /**
     * Get the scriptPath property: Case-sensitive path to folder that contains the U-SQL script. Type: string (or
     * Expression with resultType string).
     * 
     * @return the scriptPath value.
     */
    public Object scriptPath() {
        return this.scriptPath;
    }

    /**
     * Set the scriptPath property: Case-sensitive path to folder that contains the U-SQL script. Type: string (or
     * Expression with resultType string).
     * 
     * @param scriptPath the scriptPath value to set.
     * @return the DataLakeAnalyticsUsqlActivityTypeProperties object itself.
     */
    public DataLakeAnalyticsUsqlActivityTypeProperties withScriptPath(Object scriptPath) {
        this.scriptPath = scriptPath;
        return this;
    }

    /**
     * Get the scriptLinkedService property: Script linked service reference.
     * 
     * @return the scriptLinkedService value.
     */
    public LinkedServiceReference scriptLinkedService() {
        return this.scriptLinkedService;
    }

    /**
     * Set the scriptLinkedService property: Script linked service reference.
     * 
     * @param scriptLinkedService the scriptLinkedService value to set.
     * @return the DataLakeAnalyticsUsqlActivityTypeProperties object itself.
     */
    public DataLakeAnalyticsUsqlActivityTypeProperties
        withScriptLinkedService(LinkedServiceReference scriptLinkedService) {
        this.scriptLinkedService = scriptLinkedService;
        return this;
    }

    /**
     * Get the degreeOfParallelism property: The maximum number of nodes simultaneously used to run the job. Default
     * value is 1. Type: integer (or Expression with resultType integer), minimum: 1.
     * 
     * @return the degreeOfParallelism value.
     */
    public Object degreeOfParallelism() {
        return this.degreeOfParallelism;
    }

    /**
     * Set the degreeOfParallelism property: The maximum number of nodes simultaneously used to run the job. Default
     * value is 1. Type: integer (or Expression with resultType integer), minimum: 1.
     * 
     * @param degreeOfParallelism the degreeOfParallelism value to set.
     * @return the DataLakeAnalyticsUsqlActivityTypeProperties object itself.
     */
    public DataLakeAnalyticsUsqlActivityTypeProperties withDegreeOfParallelism(Object degreeOfParallelism) {
        this.degreeOfParallelism = degreeOfParallelism;
        return this;
    }

    /**
     * Get the priority property: Determines which jobs out of all that are queued should be selected to run first. The
     * lower the number, the higher the priority. Default value is 1000. Type: integer (or Expression with resultType
     * integer), minimum: 1.
     * 
     * @return the priority value.
     */
    public Object priority() {
        return this.priority;
    }

    /**
     * Set the priority property: Determines which jobs out of all that are queued should be selected to run first. The
     * lower the number, the higher the priority. Default value is 1000. Type: integer (or Expression with resultType
     * integer), minimum: 1.
     * 
     * @param priority the priority value to set.
     * @return the DataLakeAnalyticsUsqlActivityTypeProperties object itself.
     */
    public DataLakeAnalyticsUsqlActivityTypeProperties withPriority(Object priority) {
        this.priority = priority;
        return this;
    }

    /**
     * Get the parameters property: Parameters for U-SQL job request.
     * 
     * @return the parameters value.
     */
    public Map<String, Object> parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: Parameters for U-SQL job request.
     * 
     * @param parameters the parameters value to set.
     * @return the DataLakeAnalyticsUsqlActivityTypeProperties object itself.
     */
    public DataLakeAnalyticsUsqlActivityTypeProperties withParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Get the runtimeVersion property: Runtime version of the U-SQL engine to use. Type: string (or Expression with
     * resultType string).
     * 
     * @return the runtimeVersion value.
     */
    public Object runtimeVersion() {
        return this.runtimeVersion;
    }

    /**
     * Set the runtimeVersion property: Runtime version of the U-SQL engine to use. Type: string (or Expression with
     * resultType string).
     * 
     * @param runtimeVersion the runtimeVersion value to set.
     * @return the DataLakeAnalyticsUsqlActivityTypeProperties object itself.
     */
    public DataLakeAnalyticsUsqlActivityTypeProperties withRuntimeVersion(Object runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
        return this;
    }

    /**
     * Get the compilationMode property: Compilation mode of U-SQL. Must be one of these values : Semantic, Full and
     * SingleBox. Type: string (or Expression with resultType string).
     * 
     * @return the compilationMode value.
     */
    public Object compilationMode() {
        return this.compilationMode;
    }

    /**
     * Set the compilationMode property: Compilation mode of U-SQL. Must be one of these values : Semantic, Full and
     * SingleBox. Type: string (or Expression with resultType string).
     * 
     * @param compilationMode the compilationMode value to set.
     * @return the DataLakeAnalyticsUsqlActivityTypeProperties object itself.
     */
    public DataLakeAnalyticsUsqlActivityTypeProperties withCompilationMode(Object compilationMode) {
        this.compilationMode = compilationMode;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (scriptPath() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property scriptPath in model DataLakeAnalyticsUsqlActivityTypeProperties"));
        }
        if (scriptLinkedService() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property scriptLinkedService in model DataLakeAnalyticsUsqlActivityTypeProperties"));
        } else {
            scriptLinkedService().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DataLakeAnalyticsUsqlActivityTypeProperties.class);
}
