// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/**
 * Databricks SparkJar activity properties.
 */
@Fluent
public final class DatabricksSparkJarActivityTypeProperties {
    /*
     * The full name of the class containing the main method to be executed. This class must be contained in a JAR provided as a library. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "mainClassName", required = true)
    private Object mainClassName;

    /*
     * Parameters that will be passed to the main method.
     */
    @JsonProperty(value = "parameters")
    private List<Object> parameters;

    /*
     * A list of libraries to be installed on the cluster that will execute the job.
     */
    @JsonProperty(value = "libraries")
    private List<Map<String, Object>> libraries;

    /**
     * Creates an instance of DatabricksSparkJarActivityTypeProperties class.
     */
    public DatabricksSparkJarActivityTypeProperties() {
    }

    /**
     * Get the mainClassName property: The full name of the class containing the main method to be executed. This class
     * must be contained in a JAR provided as a library. Type: string (or Expression with resultType string).
     * 
     * @return the mainClassName value.
     */
    public Object mainClassName() {
        return this.mainClassName;
    }

    /**
     * Set the mainClassName property: The full name of the class containing the main method to be executed. This class
     * must be contained in a JAR provided as a library. Type: string (or Expression with resultType string).
     * 
     * @param mainClassName the mainClassName value to set.
     * @return the DatabricksSparkJarActivityTypeProperties object itself.
     */
    public DatabricksSparkJarActivityTypeProperties withMainClassName(Object mainClassName) {
        this.mainClassName = mainClassName;
        return this;
    }

    /**
     * Get the parameters property: Parameters that will be passed to the main method.
     * 
     * @return the parameters value.
     */
    public List<Object> parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: Parameters that will be passed to the main method.
     * 
     * @param parameters the parameters value to set.
     * @return the DatabricksSparkJarActivityTypeProperties object itself.
     */
    public DatabricksSparkJarActivityTypeProperties withParameters(List<Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Get the libraries property: A list of libraries to be installed on the cluster that will execute the job.
     * 
     * @return the libraries value.
     */
    public List<Map<String, Object>> libraries() {
        return this.libraries;
    }

    /**
     * Set the libraries property: A list of libraries to be installed on the cluster that will execute the job.
     * 
     * @param libraries the libraries value to set.
     * @return the DatabricksSparkJarActivityTypeProperties object itself.
     */
    public DatabricksSparkJarActivityTypeProperties withLibraries(List<Map<String, Object>> libraries) {
        this.libraries = libraries;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (mainClassName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property mainClassName in model DatabricksSparkJarActivityTypeProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DatabricksSparkJarActivityTypeProperties.class);
}
