// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.datafactory.models.Db2AuthenticationType;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * DB2 linked service properties.
 */
@Fluent
public final class Db2LinkedServiceTypeProperties {
    /*
     * The connection string. It is mutually exclusive with server, database, authenticationType, userName, packageCollection and certificateCommonName property. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JsonProperty(value = "connectionString")
    private Object connectionString;

    /*
     * Server name for connection. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "server")
    private Object server;

    /*
     * Database name for connection. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "database")
    private Object database;

    /*
     * AuthenticationType to be used for connection. It is mutually exclusive with connectionString property.
     */
    @JsonProperty(value = "authenticationType")
    private Db2AuthenticationType authenticationType;

    /*
     * Username for authentication. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "username")
    private Object username;

    /*
     * Password for authentication.
     */
    @JsonProperty(value = "password")
    private SecretBase password;

    /*
     * Under where packages are created when querying database. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "packageCollection")
    private Object packageCollection;

    /*
     * Certificate Common Name when TLS is enabled. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "certificateCommonName")
    private Object certificateCommonName;

    /*
     * The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. It is mutually exclusive with connectionString property. Type: string.
     */
    @JsonProperty(value = "encryptedCredential")
    private String encryptedCredential;

    /**
     * Creates an instance of Db2LinkedServiceTypeProperties class.
     */
    public Db2LinkedServiceTypeProperties() {
    }

    /**
     * Get the connectionString property: The connection string. It is mutually exclusive with server, database,
     * authenticationType, userName, packageCollection and certificateCommonName property. Type: string, SecureString or
     * AzureKeyVaultSecretReference.
     * 
     * @return the connectionString value.
     */
    public Object connectionString() {
        return this.connectionString;
    }

    /**
     * Set the connectionString property: The connection string. It is mutually exclusive with server, database,
     * authenticationType, userName, packageCollection and certificateCommonName property. Type: string, SecureString or
     * AzureKeyVaultSecretReference.
     * 
     * @param connectionString the connectionString value to set.
     * @return the Db2LinkedServiceTypeProperties object itself.
     */
    public Db2LinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    /**
     * Get the server property: Server name for connection. It is mutually exclusive with connectionString property.
     * Type: string (or Expression with resultType string).
     * 
     * @return the server value.
     */
    public Object server() {
        return this.server;
    }

    /**
     * Set the server property: Server name for connection. It is mutually exclusive with connectionString property.
     * Type: string (or Expression with resultType string).
     * 
     * @param server the server value to set.
     * @return the Db2LinkedServiceTypeProperties object itself.
     */
    public Db2LinkedServiceTypeProperties withServer(Object server) {
        this.server = server;
        return this;
    }

    /**
     * Get the database property: Database name for connection. It is mutually exclusive with connectionString property.
     * Type: string (or Expression with resultType string).
     * 
     * @return the database value.
     */
    public Object database() {
        return this.database;
    }

    /**
     * Set the database property: Database name for connection. It is mutually exclusive with connectionString property.
     * Type: string (or Expression with resultType string).
     * 
     * @param database the database value to set.
     * @return the Db2LinkedServiceTypeProperties object itself.
     */
    public Db2LinkedServiceTypeProperties withDatabase(Object database) {
        this.database = database;
        return this;
    }

    /**
     * Get the authenticationType property: AuthenticationType to be used for connection. It is mutually exclusive with
     * connectionString property.
     * 
     * @return the authenticationType value.
     */
    public Db2AuthenticationType authenticationType() {
        return this.authenticationType;
    }

    /**
     * Set the authenticationType property: AuthenticationType to be used for connection. It is mutually exclusive with
     * connectionString property.
     * 
     * @param authenticationType the authenticationType value to set.
     * @return the Db2LinkedServiceTypeProperties object itself.
     */
    public Db2LinkedServiceTypeProperties withAuthenticationType(Db2AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    /**
     * Get the username property: Username for authentication. It is mutually exclusive with connectionString property.
     * Type: string (or Expression with resultType string).
     * 
     * @return the username value.
     */
    public Object username() {
        return this.username;
    }

    /**
     * Set the username property: Username for authentication. It is mutually exclusive with connectionString property.
     * Type: string (or Expression with resultType string).
     * 
     * @param username the username value to set.
     * @return the Db2LinkedServiceTypeProperties object itself.
     */
    public Db2LinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    /**
     * Get the password property: Password for authentication.
     * 
     * @return the password value.
     */
    public SecretBase password() {
        return this.password;
    }

    /**
     * Set the password property: Password for authentication.
     * 
     * @param password the password value to set.
     * @return the Db2LinkedServiceTypeProperties object itself.
     */
    public Db2LinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    /**
     * Get the packageCollection property: Under where packages are created when querying database. It is mutually
     * exclusive with connectionString property. Type: string (or Expression with resultType string).
     * 
     * @return the packageCollection value.
     */
    public Object packageCollection() {
        return this.packageCollection;
    }

    /**
     * Set the packageCollection property: Under where packages are created when querying database. It is mutually
     * exclusive with connectionString property. Type: string (or Expression with resultType string).
     * 
     * @param packageCollection the packageCollection value to set.
     * @return the Db2LinkedServiceTypeProperties object itself.
     */
    public Db2LinkedServiceTypeProperties withPackageCollection(Object packageCollection) {
        this.packageCollection = packageCollection;
        return this;
    }

    /**
     * Get the certificateCommonName property: Certificate Common Name when TLS is enabled. It is mutually exclusive
     * with connectionString property. Type: string (or Expression with resultType string).
     * 
     * @return the certificateCommonName value.
     */
    public Object certificateCommonName() {
        return this.certificateCommonName;
    }

    /**
     * Set the certificateCommonName property: Certificate Common Name when TLS is enabled. It is mutually exclusive
     * with connectionString property. Type: string (or Expression with resultType string).
     * 
     * @param certificateCommonName the certificateCommonName value to set.
     * @return the Db2LinkedServiceTypeProperties object itself.
     */
    public Db2LinkedServiceTypeProperties withCertificateCommonName(Object certificateCommonName) {
        this.certificateCommonName = certificateCommonName;
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. It is mutually exclusive with connectionString property. Type:
     * string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. It is mutually exclusive with connectionString property. Type:
     * string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the Db2LinkedServiceTypeProperties object itself.
     */
    public Db2LinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (password() != null) {
            password().validate();
        }
    }
}
