// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.DatasetReference;
import com.azure.resourcemanager.datafactory.models.LogStorageSettings;
import com.azure.resourcemanager.datafactory.models.StoreReadSettings;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Delete activity properties.
 */
@Fluent
public final class DeleteActivityTypeProperties {
    /*
     * If true, files or sub-folders under current folder path will be deleted recursively. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JsonProperty(value = "recursive")
    private Object recursive;

    /*
     * The max concurrent connections to connect data source at the same time.
     */
    @JsonProperty(value = "maxConcurrentConnections")
    private Integer maxConcurrentConnections;

    /*
     * Whether to record detailed logs of delete-activity execution. Default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JsonProperty(value = "enableLogging")
    private Object enableLogging;

    /*
     * Log storage settings customer need to provide when enableLogging is true.
     */
    @JsonProperty(value = "logStorageSettings")
    private LogStorageSettings logStorageSettings;

    /*
     * Delete activity dataset reference.
     */
    @JsonProperty(value = "dataset", required = true)
    private DatasetReference dataset;

    /*
     * Delete activity store settings.
     */
    @JsonProperty(value = "storeSettings")
    private StoreReadSettings storeSettings;

    /**
     * Creates an instance of DeleteActivityTypeProperties class.
     */
    public DeleteActivityTypeProperties() {
    }

    /**
     * Get the recursive property: If true, files or sub-folders under current folder path will be deleted recursively.
     * Default is false. Type: boolean (or Expression with resultType boolean).
     * 
     * @return the recursive value.
     */
    public Object recursive() {
        return this.recursive;
    }

    /**
     * Set the recursive property: If true, files or sub-folders under current folder path will be deleted recursively.
     * Default is false. Type: boolean (or Expression with resultType boolean).
     * 
     * @param recursive the recursive value to set.
     * @return the DeleteActivityTypeProperties object itself.
     */
    public DeleteActivityTypeProperties withRecursive(Object recursive) {
        this.recursive = recursive;
        return this;
    }

    /**
     * Get the maxConcurrentConnections property: The max concurrent connections to connect data source at the same
     * time.
     * 
     * @return the maxConcurrentConnections value.
     */
    public Integer maxConcurrentConnections() {
        return this.maxConcurrentConnections;
    }

    /**
     * Set the maxConcurrentConnections property: The max concurrent connections to connect data source at the same
     * time.
     * 
     * @param maxConcurrentConnections the maxConcurrentConnections value to set.
     * @return the DeleteActivityTypeProperties object itself.
     */
    public DeleteActivityTypeProperties withMaxConcurrentConnections(Integer maxConcurrentConnections) {
        this.maxConcurrentConnections = maxConcurrentConnections;
        return this;
    }

    /**
     * Get the enableLogging property: Whether to record detailed logs of delete-activity execution. Default value is
     * false. Type: boolean (or Expression with resultType boolean).
     * 
     * @return the enableLogging value.
     */
    public Object enableLogging() {
        return this.enableLogging;
    }

    /**
     * Set the enableLogging property: Whether to record detailed logs of delete-activity execution. Default value is
     * false. Type: boolean (or Expression with resultType boolean).
     * 
     * @param enableLogging the enableLogging value to set.
     * @return the DeleteActivityTypeProperties object itself.
     */
    public DeleteActivityTypeProperties withEnableLogging(Object enableLogging) {
        this.enableLogging = enableLogging;
        return this;
    }

    /**
     * Get the logStorageSettings property: Log storage settings customer need to provide when enableLogging is true.
     * 
     * @return the logStorageSettings value.
     */
    public LogStorageSettings logStorageSettings() {
        return this.logStorageSettings;
    }

    /**
     * Set the logStorageSettings property: Log storage settings customer need to provide when enableLogging is true.
     * 
     * @param logStorageSettings the logStorageSettings value to set.
     * @return the DeleteActivityTypeProperties object itself.
     */
    public DeleteActivityTypeProperties withLogStorageSettings(LogStorageSettings logStorageSettings) {
        this.logStorageSettings = logStorageSettings;
        return this;
    }

    /**
     * Get the dataset property: Delete activity dataset reference.
     * 
     * @return the dataset value.
     */
    public DatasetReference dataset() {
        return this.dataset;
    }

    /**
     * Set the dataset property: Delete activity dataset reference.
     * 
     * @param dataset the dataset value to set.
     * @return the DeleteActivityTypeProperties object itself.
     */
    public DeleteActivityTypeProperties withDataset(DatasetReference dataset) {
        this.dataset = dataset;
        return this;
    }

    /**
     * Get the storeSettings property: Delete activity store settings.
     * 
     * @return the storeSettings value.
     */
    public StoreReadSettings storeSettings() {
        return this.storeSettings;
    }

    /**
     * Set the storeSettings property: Delete activity store settings.
     * 
     * @param storeSettings the storeSettings value to set.
     * @return the DeleteActivityTypeProperties object itself.
     */
    public DeleteActivityTypeProperties withStoreSettings(StoreReadSettings storeSettings) {
        this.storeSettings = storeSettings;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (logStorageSettings() != null) {
            logStorageSettings().validate();
        }
        if (dataset() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property dataset in model DeleteActivityTypeProperties"));
        } else {
            dataset().validate();
        }
        if (storeSettings() != null) {
            storeSettings().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DeleteActivityTypeProperties.class);
}
