// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.DatasetLocation;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * DelimitedText dataset properties.
 */
@Fluent
public final class DelimitedTextDatasetTypeProperties {
    /*
     * The location of the delimited text storage.
     */
    @JsonProperty(value = "location", required = true)
    private DatasetLocation location;

    /*
     * The column delimiter. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "columnDelimiter")
    private Object columnDelimiter;

    /*
     * The row delimiter. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "rowDelimiter")
    private Object rowDelimiter;

    /*
     * The code page name of the preferred encoding. If miss, the default value is UTF-8, unless BOM denotes another Unicode encoding. Refer to the name column of the table in the following link to set supported values: https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "encodingName")
    private Object encodingName;

    /*
     * The data compressionCodec. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "compressionCodec")
    private Object compressionCodec;

    /*
     * The data compression method used for DelimitedText.
     */
    @JsonProperty(value = "compressionLevel")
    private Object compressionLevel;

    /*
     * The quote character. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "quoteChar")
    private Object quoteChar;

    /*
     * The escape character. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "escapeChar")
    private Object escapeChar;

    /*
     * When used as input, treat the first row of data as headers. When used as output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JsonProperty(value = "firstRowAsHeader")
    private Object firstRowAsHeader;

    /*
     * The null value string. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "nullValue")
    private Object nullValue;

    /**
     * Creates an instance of DelimitedTextDatasetTypeProperties class.
     */
    public DelimitedTextDatasetTypeProperties() {
    }

    /**
     * Get the location property: The location of the delimited text storage.
     * 
     * @return the location value.
     */
    public DatasetLocation location() {
        return this.location;
    }

    /**
     * Set the location property: The location of the delimited text storage.
     * 
     * @param location the location value to set.
     * @return the DelimitedTextDatasetTypeProperties object itself.
     */
    public DelimitedTextDatasetTypeProperties withLocation(DatasetLocation location) {
        this.location = location;
        return this;
    }

    /**
     * Get the columnDelimiter property: The column delimiter. Type: string (or Expression with resultType string).
     * 
     * @return the columnDelimiter value.
     */
    public Object columnDelimiter() {
        return this.columnDelimiter;
    }

    /**
     * Set the columnDelimiter property: The column delimiter. Type: string (or Expression with resultType string).
     * 
     * @param columnDelimiter the columnDelimiter value to set.
     * @return the DelimitedTextDatasetTypeProperties object itself.
     */
    public DelimitedTextDatasetTypeProperties withColumnDelimiter(Object columnDelimiter) {
        this.columnDelimiter = columnDelimiter;
        return this;
    }

    /**
     * Get the rowDelimiter property: The row delimiter. Type: string (or Expression with resultType string).
     * 
     * @return the rowDelimiter value.
     */
    public Object rowDelimiter() {
        return this.rowDelimiter;
    }

    /**
     * Set the rowDelimiter property: The row delimiter. Type: string (or Expression with resultType string).
     * 
     * @param rowDelimiter the rowDelimiter value to set.
     * @return the DelimitedTextDatasetTypeProperties object itself.
     */
    public DelimitedTextDatasetTypeProperties withRowDelimiter(Object rowDelimiter) {
        this.rowDelimiter = rowDelimiter;
        return this;
    }

    /**
     * Get the encodingName property: The code page name of the preferred encoding. If miss, the default value is UTF-8,
     * unless BOM denotes another Unicode encoding. Refer to the name column of the table in the following link to set
     * supported values: https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with
     * resultType string).
     * 
     * @return the encodingName value.
     */
    public Object encodingName() {
        return this.encodingName;
    }

    /**
     * Set the encodingName property: The code page name of the preferred encoding. If miss, the default value is UTF-8,
     * unless BOM denotes another Unicode encoding. Refer to the name column of the table in the following link to set
     * supported values: https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with
     * resultType string).
     * 
     * @param encodingName the encodingName value to set.
     * @return the DelimitedTextDatasetTypeProperties object itself.
     */
    public DelimitedTextDatasetTypeProperties withEncodingName(Object encodingName) {
        this.encodingName = encodingName;
        return this;
    }

    /**
     * Get the compressionCodec property: The data compressionCodec. Type: string (or Expression with resultType
     * string).
     * 
     * @return the compressionCodec value.
     */
    public Object compressionCodec() {
        return this.compressionCodec;
    }

    /**
     * Set the compressionCodec property: The data compressionCodec. Type: string (or Expression with resultType
     * string).
     * 
     * @param compressionCodec the compressionCodec value to set.
     * @return the DelimitedTextDatasetTypeProperties object itself.
     */
    public DelimitedTextDatasetTypeProperties withCompressionCodec(Object compressionCodec) {
        this.compressionCodec = compressionCodec;
        return this;
    }

    /**
     * Get the compressionLevel property: The data compression method used for DelimitedText.
     * 
     * @return the compressionLevel value.
     */
    public Object compressionLevel() {
        return this.compressionLevel;
    }

    /**
     * Set the compressionLevel property: The data compression method used for DelimitedText.
     * 
     * @param compressionLevel the compressionLevel value to set.
     * @return the DelimitedTextDatasetTypeProperties object itself.
     */
    public DelimitedTextDatasetTypeProperties withCompressionLevel(Object compressionLevel) {
        this.compressionLevel = compressionLevel;
        return this;
    }

    /**
     * Get the quoteChar property: The quote character. Type: string (or Expression with resultType string).
     * 
     * @return the quoteChar value.
     */
    public Object quoteChar() {
        return this.quoteChar;
    }

    /**
     * Set the quoteChar property: The quote character. Type: string (or Expression with resultType string).
     * 
     * @param quoteChar the quoteChar value to set.
     * @return the DelimitedTextDatasetTypeProperties object itself.
     */
    public DelimitedTextDatasetTypeProperties withQuoteChar(Object quoteChar) {
        this.quoteChar = quoteChar;
        return this;
    }

    /**
     * Get the escapeChar property: The escape character. Type: string (or Expression with resultType string).
     * 
     * @return the escapeChar value.
     */
    public Object escapeChar() {
        return this.escapeChar;
    }

    /**
     * Set the escapeChar property: The escape character. Type: string (or Expression with resultType string).
     * 
     * @param escapeChar the escapeChar value to set.
     * @return the DelimitedTextDatasetTypeProperties object itself.
     */
    public DelimitedTextDatasetTypeProperties withEscapeChar(Object escapeChar) {
        this.escapeChar = escapeChar;
        return this;
    }

    /**
     * Get the firstRowAsHeader property: When used as input, treat the first row of data as headers. When used as
     * output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or
     * Expression with resultType boolean).
     * 
     * @return the firstRowAsHeader value.
     */
    public Object firstRowAsHeader() {
        return this.firstRowAsHeader;
    }

    /**
     * Set the firstRowAsHeader property: When used as input, treat the first row of data as headers. When used as
     * output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or
     * Expression with resultType boolean).
     * 
     * @param firstRowAsHeader the firstRowAsHeader value to set.
     * @return the DelimitedTextDatasetTypeProperties object itself.
     */
    public DelimitedTextDatasetTypeProperties withFirstRowAsHeader(Object firstRowAsHeader) {
        this.firstRowAsHeader = firstRowAsHeader;
        return this;
    }

    /**
     * Get the nullValue property: The null value string. Type: string (or Expression with resultType string).
     * 
     * @return the nullValue value.
     */
    public Object nullValue() {
        return this.nullValue;
    }

    /**
     * Set the nullValue property: The null value string. Type: string (or Expression with resultType string).
     * 
     * @param nullValue the nullValue value to set.
     * @return the DelimitedTextDatasetTypeProperties object itself.
     */
    public DelimitedTextDatasetTypeProperties withNullValue(Object nullValue) {
        this.nullValue = nullValue;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (location() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property location in model DelimitedTextDatasetTypeProperties"));
        } else {
            location().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DelimitedTextDatasetTypeProperties.class);
}
